/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.geolocation;

import com.liferay.portal.search.geolocation.Coordinate;
import com.liferay.portal.search.geolocation.MultiPolygonShape;
import com.liferay.portal.search.geolocation.MultiPolygonShapeBuilder;
import com.liferay.portal.search.geolocation.Orientation;
import com.liferay.portal.search.geolocation.PolygonShape;
import com.liferay.portal.search.geolocation.ShapeTranslator;
import com.liferay.portal.search.internal.geolocation.BaseShapeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultiPolygonShapeImpl
extends BaseShapeImpl
implements MultiPolygonShape {
    private Orientation _orientation;
    private final List<PolygonShape> _polygonShapes = new ArrayList<PolygonShape>();

    public <T> T accept(ShapeTranslator<T> shapeTranslator) {
        return (T)shapeTranslator.translate((MultiPolygonShape)this);
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public List<PolygonShape> getPolygonShapes() {
        return Collections.unmodifiableList(this._polygonShapes);
    }

    protected MultiPolygonShapeImpl() {
    }

    protected MultiPolygonShapeImpl(MultiPolygonShapeImpl multiPolygonShapeImpl) {
        this._orientation = multiPolygonShapeImpl._orientation;
        this._polygonShapes.addAll(multiPolygonShapeImpl._polygonShapes);
        this.setCoordinates(multiPolygonShapeImpl.getCoordinates());
    }

    public static class MultiPolygonShapeBuilderImpl
    implements MultiPolygonShapeBuilder {
        private final MultiPolygonShapeImpl _multiPolygonShapeImpl = new MultiPolygonShapeImpl();

        public MultiPolygonShapeBuilder addCoordinate(Coordinate coordinate) {
            this._multiPolygonShapeImpl.addCoordinate(coordinate);
            return this;
        }

        public MultiPolygonShapeBuilder addPolygonShape(PolygonShape polygonShape) {
            this._multiPolygonShapeImpl._polygonShapes.add(polygonShape);
            return this;
        }

        public MultiPolygonShape build() {
            return new MultiPolygonShapeImpl(this._multiPolygonShapeImpl);
        }

        public MultiPolygonShapeBuilder coordinates(Coordinate ... coordinates) {
            this._multiPolygonShapeImpl.setCoordinates(coordinates);
            return this;
        }

        public MultiPolygonShapeBuilder coordinates(List<Coordinate> coordinates) {
            this._multiPolygonShapeImpl.setCoordinates(coordinates);
            return this;
        }

        public MultiPolygonShapeBuilder orientation(Orientation orientation) {
            this._multiPolygonShapeImpl._orientation = orientation;
            return this;
        }

        public MultiPolygonShapeBuilder polygonShapes(PolygonShape ... polygonShapes) {
            this._multiPolygonShapeImpl._polygonShapes.clear();
            Collections.addAll(this._multiPolygonShapeImpl._polygonShapes, polygonShapes);
            return this;
        }
    }
}

