/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.filter.range;

import com.liferay.portal.search.internal.filter.range.RangeTermQueryValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RangeTermQueryValueParser {
    private static final Pattern _pattern = Pattern.compile("\\s*(?<lowerBracket>[\\]\\[])(?<lowerBound>\\S+)\\s+(?<upperBound>\\S+)(?<upperBracket>[\\]\\[])\\s*");

    public RangeTermQueryValue parse(String value) {
        Matcher matcher = _pattern.matcher(value);
        if (!matcher.matches()) {
            return null;
        }
        RangeTermQueryValue.Builder rangeTermQueryValueBuilder = new RangeTermQueryValue.Builder();
        rangeTermQueryValueBuilder.includesLower(this.isIncludesLower(matcher));
        rangeTermQueryValueBuilder.includesUpper(this.isIncludesUpper(matcher));
        rangeTermQueryValueBuilder.lowerBound(matcher.group("lowerBound"));
        rangeTermQueryValueBuilder.upperBound(matcher.group("upperBound"));
        return rangeTermQueryValueBuilder.build();
    }

    protected boolean isIncludesLower(Matcher matcher) {
        String lowerBracket = matcher.group("lowerBracket");
        return lowerBracket.equals("[");
    }

    protected boolean isIncludesUpper(Matcher matcher) {
        String upperBracket = matcher.group("upperBracket");
        return upperBracket.equals("]");
    }
}

