/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.facet.custom;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.search.facet.custom.CustomFacetFactory;
import com.liferay.portal.search.facet.custom.CustomFacetSearchContributor;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CustomFacetSearchContributor.class})
public class CustomFacetSearchContributorImpl
implements CustomFacetSearchContributor {
    @Reference
    private CustomFacetFactory _customFacetFactory;

    public void contribute(SearchRequestBuilder searchRequestBuilder, Consumer<CustomFacetSearchContributor.CustomFacetBuilder> customFacetBuilderConsumer) {
        com.liferay.portal.search.facet.Facet facet = (com.liferay.portal.search.facet.Facet)searchRequestBuilder.withSearchContextGet(searchContext -> {
            CustomFacetBuilderImpl customFacetBuilderImpl = new CustomFacetBuilderImpl((SearchContext)searchContext);
            customFacetBuilderConsumer.accept(customFacetBuilderImpl);
            return customFacetBuilderImpl.build();
        });
        searchRequestBuilder.withFacetContext(facetContext -> facetContext.addFacet((Facet)facet));
    }

    private class CustomFacetBuilderImpl
    implements CustomFacetSearchContributor.CustomFacetBuilder {
        private String _aggregationName;
        private String _fieldToAggregate;
        private int _frequencyThreshold;
        private int _maxTerms;
        private final SearchContext _searchContext;
        private String[] _selectedValues;

        public CustomFacetBuilderImpl(SearchContext searchContext) {
            this._searchContext = searchContext;
        }

        public CustomFacetSearchContributor.CustomFacetBuilder aggregationName(String aggregationName) {
            this._aggregationName = aggregationName;
            return this;
        }

        public com.liferay.portal.search.facet.Facet build() {
            com.liferay.portal.search.facet.Facet facet = CustomFacetSearchContributorImpl.this._customFacetFactory.newInstance(this._searchContext);
            facet.setAggregationName(this._aggregationName);
            facet.setFacetConfiguration(this.buildFacetConfiguration(facet));
            facet.setFieldName(this._fieldToAggregate);
            facet.select(this._selectedValues);
            return facet;
        }

        public CustomFacetSearchContributor.CustomFacetBuilder fieldToAggregate(String fieldToAggregate) {
            this._fieldToAggregate = fieldToAggregate;
            return this;
        }

        public CustomFacetSearchContributor.CustomFacetBuilder frequencyThreshold(int frequencyThreshold) {
            this._frequencyThreshold = frequencyThreshold;
            return this;
        }

        public CustomFacetSearchContributor.CustomFacetBuilder maxTerms(int maxTerms) {
            this._maxTerms = maxTerms;
            return this;
        }

        public CustomFacetSearchContributor.CustomFacetBuilder selectedValues(String ... selectedValues) {
            this._selectedValues = selectedValues;
            return this;
        }

        protected FacetConfiguration buildFacetConfiguration(com.liferay.portal.search.facet.Facet facet) {
            FacetConfiguration facetConfiguration = new FacetConfiguration();
            facetConfiguration.setFieldName(facet.getFieldName());
            facetConfiguration.setOrder("OrderHitsDesc");
            facetConfiguration.setStatic(false);
            facetConfiguration.setWeight(1.1);
            JSONObject jsonObject = facetConfiguration.getData();
            jsonObject.put("frequencyThreshold", this._frequencyThreshold).put("maxTerms", this._maxTerms);
            return facetConfiguration;
        }
    }
}

