/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.facet.category;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.facet.category.CategoryFacetFactory;
import com.liferay.portal.search.facet.category.CategoryFacetSearchContributor;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CategoryFacetSearchContributor.class})
public class CategoryFacetSearchContributorImpl
implements CategoryFacetSearchContributor {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private CategoryFacetFactory _categoryFacetFactory;

    public void contribute(SearchRequestBuilder searchRequestBuilder, Consumer<CategoryFacetSearchContributor.CategoryFacetBuilder> categoryFacetBuilderConsumer) {
        com.liferay.portal.search.facet.Facet facet = (com.liferay.portal.search.facet.Facet)searchRequestBuilder.withSearchContextGet(searchContext -> {
            CategoryFacetBuilderImpl categoryFacetBuilderImpl = new CategoryFacetBuilderImpl((SearchContext)searchContext);
            categoryFacetBuilderConsumer.accept(categoryFacetBuilderImpl);
            return categoryFacetBuilderImpl.build();
        });
        searchRequestBuilder.withFacetContext(facetContext -> facetContext.addFacet((Facet)facet));
    }

    private class CategoryFacetBuilderImpl
    implements CategoryFacetSearchContributor.CategoryFacetBuilder {
        private String _aggregationName;
        private int _frequencyThreshold;
        private int _maxTerms;
        private final SearchContext _searchContext;
        private long[] _selectedCategoryIds;
        private String[] _vocabularyIds;

        public CategoryFacetBuilderImpl(SearchContext searchContext) {
            this._searchContext = searchContext;
        }

        public CategoryFacetSearchContributor.CategoryFacetBuilder aggregationName(String aggregationName) {
            this._aggregationName = aggregationName;
            return this;
        }

        public com.liferay.portal.search.facet.Facet build() {
            com.liferay.portal.search.facet.Facet facet = CategoryFacetSearchContributorImpl.this._categoryFacetFactory.newInstance(this._searchContext);
            facet.setAggregationName(this._aggregationName);
            facet.setFacetConfiguration(this.buildFacetConfiguration(facet));
            if (this._selectedCategoryIds != null) {
                String fieldName = facet.getFieldName();
                if (fieldName.equals("assetVocabularyCategoryIds")) {
                    facet.select(this._getSelections(this._selectedCategoryIds));
                } else {
                    facet.select(ArrayUtil.toStringArray((long[])this._selectedCategoryIds));
                }
            }
            return facet;
        }

        public CategoryFacetSearchContributor.CategoryFacetBuilder frequencyThreshold(int frequencyThreshold) {
            this._frequencyThreshold = frequencyThreshold;
            return this;
        }

        public CategoryFacetSearchContributor.CategoryFacetBuilder maxTerms(int maxTerms) {
            this._maxTerms = maxTerms;
            return this;
        }

        public CategoryFacetSearchContributor.CategoryFacetBuilder selectedCategoryIds(long ... selectedCategoryIds) {
            this._selectedCategoryIds = selectedCategoryIds;
            return this;
        }

        public CategoryFacetSearchContributor.CategoryFacetBuilder vocabularyIds(String[] vocabularyIds) {
            this._vocabularyIds = vocabularyIds;
            return this;
        }

        protected FacetConfiguration buildFacetConfiguration(com.liferay.portal.search.facet.Facet facet) {
            FacetConfiguration facetConfiguration = new FacetConfiguration();
            facetConfiguration.setFieldName(facet.getFieldName());
            facetConfiguration.setLabel("any-category");
            facetConfiguration.setOrder("OrderHitsDesc");
            facetConfiguration.setStatic(false);
            facetConfiguration.setWeight(1.6);
            JSONObject jsonObject = facetConfiguration.getData();
            jsonObject.put("frequencyThreshold", this._frequencyThreshold).put("include", this._getIncludeRegexString(facet.getFieldName())).put("maxTerms", this._maxTerms);
            return facetConfiguration;
        }

        private String _getIncludeRegexString(String fieldName) {
            if (ArrayUtil.isEmpty((Object[])this._vocabularyIds) || fieldName.equals("assetCategoryIds")) {
                return null;
            }
            StringBundler sb = new StringBundler(this._vocabularyIds.length * 5);
            for (String vocabularyId : this._vocabularyIds) {
                sb.append(vocabularyId);
                sb.append("-");
                sb.append(".");
                sb.append("*");
                sb.append("|");
            }
            if (sb.index() > 0) {
                sb.setIndex(sb.index() - 1);
                return sb.toString();
            }
            return null;
        }

        private String[] _getSelections(long[] selectedCategoryIds) {
            String[] selections = new String[selectedCategoryIds.length];
            for (int i = 0; i < selectedCategoryIds.length; ++i) {
                AssetCategory assetCategory = CategoryFacetSearchContributorImpl.this._assetCategoryLocalService.fetchAssetCategory(selectedCategoryIds[i]);
                selections[i] = assetCategory.getVocabularyId() + "-" + assetCategory.getCategoryId();
            }
            return selections;
        }
    }
}

