/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.facet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.search.facet.collector.TermCollector;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleFacetCollector
implements FacetCollector {
    private final String _fieldName;
    private final Map<String, TermCollector> _termCollectors = new HashMap<String, TermCollector>();

    public SimpleFacetCollector(String fieldName, List<TermCollector> termCollectors) {
        this._fieldName = fieldName;
        for (TermCollector termCollector : termCollectors) {
            this._termCollectors.put(termCollector.getTerm(), termCollector);
        }
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public TermCollector getTermCollector(String term) {
        return this._termCollectors.get(term);
    }

    public List<TermCollector> getTermCollectors() {
        return ListUtil.sort((List)ListUtil.fromMapValues(this._termCollectors), Comparator.comparing(TermCollector::getFrequency, Comparator.reverseOrder()));
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{fieldName=", this._fieldName, ", termCollectors=", this._termCollectors, "}"});
    }
}

