/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.buffer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.configuration.IndexerRegistryConfiguration;
import com.liferay.portal.search.internal.buffer.BufferOverflowThreadLocal;
import com.liferay.portal.search.internal.buffer.IndexerRequestBuffer;
import com.liferay.portal.search.internal.buffer.IndexerRequestBufferExecutor;
import com.liferay.portal.search.internal.buffer.IndexerRequestBufferExecutorWatcher;
import com.liferay.portal.search.internal.buffer.IndexerRequestBufferOverflowHandler;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.configuration.IndexerRegistryConfiguration"}, immediate=true, property={"mode=DEFAULT"}, service={IndexerRequestBufferOverflowHandler.class})
public class DefaultIndexerRequestBufferOverflowHandler
implements IndexerRequestBufferOverflowHandler {
    @Reference
    protected IndexerRequestBufferExecutorWatcher indexerRequestBufferExecutorWatcher;
    private static final float _DEFAULT_MINIMUM_BUFFER_AVAILABILITY_PERCENTAGE = 0.9f;
    private static final Log _log = LogFactoryUtil.getLog(DefaultIndexerRequestBufferOverflowHandler.class);
    private volatile float _minimumBufferAvailabilityPercentage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bufferOverflowed(IndexerRequestBuffer indexerRequestBuffer, int maxBufferSize) {
        int currentBufferSize = indexerRequestBuffer.size();
        if (currentBufferSize < maxBufferSize) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Buffer size is less than maximum: " + maxBufferSize));
            }
            return false;
        }
        int numRequests = Math.round((float)currentBufferSize - Math.abs((float)maxBufferSize * this._minimumBufferAvailabilityPercentage));
        if (numRequests > 0) {
            try {
                BufferOverflowThreadLocal.setOverflowMode(true);
                IndexerRequestBufferExecutor indexerRequestBufferExecutor = this.indexerRequestBufferExecutorWatcher.getIndexerRequestBufferExecutor();
                indexerRequestBufferExecutor.execute(indexerRequestBuffer, numRequests);
            }
            finally {
                BufferOverflowThreadLocal.setOverflowMode(false);
            }
        }
        return true;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        IndexerRegistryConfiguration indexerRegistryConfiguration = (IndexerRegistryConfiguration)ConfigurableUtil.createConfigurable(IndexerRegistryConfiguration.class, properties);
        float minimumBufferAvailabilityPercentage = indexerRegistryConfiguration.minimumBufferAvailabilityPercentage();
        if ((minimumBufferAvailabilityPercentage > 1.0f || (double)minimumBufferAvailabilityPercentage < 0.1) && _log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Invalid minimum buffer availability percentage: ", Float.valueOf(minimumBufferAvailabilityPercentage), ", using default value", Float.valueOf(0.9f)}));
        }
        this._minimumBufferAvailabilityPercentage = minimumBufferAvailabilityPercentage;
    }
}

