/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.buffer;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.ResourcedModel;
import com.liferay.portal.kernel.search.Bufferable;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.search.configuration.IndexerRegistryConfiguration;
import com.liferay.portal.search.index.IndexStatusManager;
import com.liferay.portal.search.internal.buffer.IndexerRequest;
import com.liferay.portal.search.internal.buffer.IndexerRequestBuffer;
import com.liferay.portal.search.internal.buffer.IndexerRequestBufferHandler;
import com.liferay.portal.search.internal.buffer.IndexerRequestBufferOverflowHandler;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class BufferedIndexerInvocationHandler
implements InvocationHandler {
    private static final Log _log = LogFactoryUtil.getLog(BufferedIndexerInvocationHandler.class);
    private final Indexer<?> _indexer;
    private volatile IndexerRegistryConfiguration _indexerRegistryConfiguration;
    private volatile IndexerRequestBufferOverflowHandler _indexerRequestBufferOverflowHandler;
    private final IndexStatusManager _indexStatusManager;
    private final PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;

    public BufferedIndexerInvocationHandler(Indexer<?> indexer, IndexStatusManager indexStatusManager, IndexerRegistryConfiguration indexerRegistryConfiguration, PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry) {
        this._indexer = indexer;
        this._indexStatusManager = indexStatusManager;
        this._indexerRegistryConfiguration = indexerRegistryConfiguration;
        this._persistedModelLocalServiceRegistry = persistedModelLocalServiceRegistry;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Bufferable annotation = method.getAnnotation(Bufferable.class);
        IndexerRequestBuffer indexerRequestBuffer = IndexerRequestBuffer.get();
        if (annotation == null || args.length == 0 || args.length > 2 || indexerRequestBuffer == null) {
            return method.invoke(this._indexer, args);
        }
        if (this._indexStatusManager.isIndexReadOnly()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Skipping indexer request buffer because index is read only");
            }
            return null;
        }
        if (CompanyThreadLocal.isDeleteInProcess()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Skipping indexer request buffer because a company delete is in process");
            }
            return null;
        }
        Class<?> args0Class = args[0].getClass();
        if (!(args[0] instanceof BaseModel || args[0] instanceof ClassedModel || args0Class.isArray() || Collection.class.isAssignableFrom(args0Class) || args.length == 2 && args[0] instanceof String && Objects.equals(args[1].getClass(), Long.class))) {
            return method.invoke(this._indexer, args);
        }
        if (args[0] instanceof ClassedModel && Objects.equals(method.getName(), "reindex")) {
            MethodKey methodKey = new MethodKey(Indexer.class, method.getName(), new Class[]{String.class, Long.TYPE});
            ClassedModel classedModel = (ClassedModel)args[0];
            Long classPK = (Long)classedModel.getPrimaryKeyObj();
            if (args[0] instanceof ResourcedModel) {
                ResourcedModel resourcedModel = (ResourcedModel)args[0];
                classPK = resourcedModel.getResourcePrimKey();
            }
            this.bufferRequest(methodKey, classedModel.getModelClassName(), classPK, indexerRequestBuffer);
        } else if (args[0] instanceof ClassedModel) {
            MethodKey methodKey = new MethodKey(Indexer.class, method.getName(), new Class[]{Object.class});
            this.bufferRequest(methodKey, args[0], indexerRequestBuffer);
        } else if (args.length == 2) {
            void var10_20;
            String className;
            MethodKey methodKey;
            block18: {
                methodKey = new MethodKey(Indexer.class, method.getName(), new Class[]{String.class, Long.TYPE});
                className = (String)args[0];
                PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(className);
                Long l = (Long)args[1];
                try {
                    PersistedModel object = persistedModelLocalService.getPersistedModel((Serializable)l);
                    if (object instanceof ResourcedModel) {
                        ResourcedModel resourcedModel = (ResourcedModel)object;
                        Long l2 = resourcedModel.getResourcePrimKey();
                    }
                }
                catch (Exception exception) {
                    if (!_log.isTraceEnabled()) break block18;
                    _log.trace((Throwable)exception);
                }
            }
            this.bufferRequest(methodKey, className, (Long)var10_20, indexerRequestBuffer);
        } else {
            MethodKey methodKey = new MethodKey(Indexer.class, method.getName(), new Class[]{Object.class});
            List<Object> objects = null;
            objects = args0Class.isArray() ? Arrays.asList((Object[])args[0]) : (List<Object>)args[0];
            for (Object e : objects) {
                if (!(e instanceof ClassedModel)) {
                    return method.invoke(this._indexer, args);
                }
                this.bufferRequest(methodKey, e, indexerRequestBuffer);
            }
        }
        return null;
    }

    public void setIndexerRegistryConfiguration(IndexerRegistryConfiguration indexerRegistryConfiguration) {
        this._indexerRegistryConfiguration = indexerRegistryConfiguration;
    }

    public void setIndexerRequestBufferOverflowHandler(IndexerRequestBufferOverflowHandler indexerRequestBufferOverflowHandler) {
        this._indexerRequestBufferOverflowHandler = indexerRequestBufferOverflowHandler;
    }

    protected void bufferRequest(MethodKey methodKey, Object object, IndexerRequestBuffer indexerRequestBuffer) throws Exception {
        BaseModel baseModel = (BaseModel)object;
        ClassedModel classedModel = (ClassedModel)baseModel.clone();
        IndexerRequest indexerRequest = new IndexerRequest(methodKey.getMethod(), classedModel, this._indexer);
        this._bufferRequest(indexerRequest, indexerRequestBuffer);
    }

    protected void bufferRequest(MethodKey methodKey, String className, Long classPK, IndexerRequestBuffer indexerRequestBuffer) throws Exception {
        if (this._indexStatusManager.isIndexReadOnly(className)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping indexer request buffer because index for " + className + " is read only"));
            }
            return;
        }
        IndexerRequest indexerRequest = new IndexerRequest(methodKey.getMethod(), this._indexer, className, classPK);
        this._bufferRequest(indexerRequest, indexerRequestBuffer);
    }

    private void _bufferRequest(IndexerRequest indexerRequest, IndexerRequestBuffer indexerRequestBuffer) throws Exception {
        IndexerRequestBufferHandler indexerRequestBufferHandler = new IndexerRequestBufferHandler(this._indexerRequestBufferOverflowHandler, this._indexerRegistryConfiguration);
        indexerRequestBufferHandler.bufferRequest(indexerRequest, indexerRequestBuffer);
    }
}

