/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.buffer;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.search.internal.buffer.IndexerRequest;
import com.liferay.portal.search.internal.buffer.IndexerRequestBuffer;
import com.liferay.portal.search.internal.buffer.IndexerRequestBufferExecutor;

public abstract class BaseIndexerRequestBufferExecutor
implements IndexerRequestBufferExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BaseIndexerRequestBufferExecutor.class);

    @Override
    public void execute(IndexerRequestBuffer indexerRequestBuffer) {
        this.execute(indexerRequestBuffer, indexerRequestBuffer.size());
    }

    protected void commit() {
        block4: {
            IndexWriterHelper indexWriterHelper = this.getIndexWriterHelper();
            if (indexWriterHelper == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Index writer helper is null");
                }
                return;
            }
            try {
                indexWriterHelper.commit();
            }
            catch (SearchException searchException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)"Unable to commit search engine", (Throwable)searchException);
            }
        }
    }

    protected void executeIndexerRequest(IndexerRequest indexerRequest) {
        block2: {
            try {
                indexerRequest.execute();
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to execute index request " + indexerRequest), (Throwable)exception);
            }
        }
    }

    protected abstract IndexWriterHelper getIndexWriterHelper();
}

