/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.background.task;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.search.background.task.ReindexStatusMessageSender;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.internal.background.task.BaseReindexBackgroundTaskExecutor;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"background.task.executor.class.name=com.liferay.portal.search.internal.background.task.ReindexSingleIndexerBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class, ReindexSingleIndexerBackgroundTaskExecutor.class})
public class ReindexSingleIndexerBackgroundTaskExecutor
extends BaseReindexBackgroundTaskExecutor {
    protected static volatile IndexWriterHelper indexWriterHelper = (IndexWriterHelper)ServiceProxyFactory.newServiceTrackedInstance(IndexWriterHelper.class, ReindexSingleIndexerBackgroundTaskExecutor.class, (String)"indexWriterHelper", (boolean)true);
    @Reference
    protected IndexerRegistry indexerRegistry;
    @Reference
    protected ReindexStatusMessageSender reindexStatusMessageSender;
    @Reference
    protected SearchEngineHelper searchEngineHelper;
    protected ServiceTrackerList<Indexer<?>> systemIndexers;
    private static final Log _log = LogFactoryUtil.getLog(ReindexSingleIndexerBackgroundTaskExecutor.class);

    public ReindexSingleIndexerBackgroundTaskExecutor() {
        this.setIsolationLevel(5);
    }

    public BackgroundTaskExecutor clone() {
        return this;
    }

    public String generateLockKey(BackgroundTask backgroundTask) {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        String className = (String)taskContextMap.get("className");
        if (Validator.isNotNull((String)className)) {
            return className;
        }
        return super.generateLockKey(backgroundTask);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.systemIndexers = ServiceTrackerListFactory.open((BundleContext)bundleContext, Indexer.class, (String)"(system.index=true)");
    }

    @Deactivate
    protected void deactivate() {
        if (this.systemIndexers != null) {
            this.systemIndexers.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reindex(String className, long[] companyIds) throws Exception {
        Indexer indexer = this.indexerRegistry.getIndexer(className);
        if (indexer == null) {
            return;
        }
        SearchEngine searchEngine = this.searchEngineHelper.getSearchEngine();
        boolean systemIndexer = this._isSystemIndexer(indexer);
        for (long companyId : companyIds) {
            if (companyId == 0L && !systemIndexer || companyId != 0L && systemIndexer) continue;
            this.reindexStatusMessageSender.sendStatusMessage("singleStart", companyId, companyIds);
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Start reindexing company ", companyId, " for class name ", className}));
            }
            try {
                searchEngine.initialize(companyId);
                indexWriterHelper.deleteEntityDocuments(companyId, className, true);
                indexer.reindex(new String[]{String.valueOf(companyId)});
            }
            catch (Exception exception) {
                try {
                    _log.error((Throwable)exception);
                }
                catch (Throwable throwable) {
                    this.reindexStatusMessageSender.sendStatusMessage("singleEnd", companyId, companyIds);
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)StringBundler.concat((Object[])new Object[]{"Finished reindexing company ", companyId, " for class name ", className}));
                    }
                    throw throwable;
                }
                this.reindexStatusMessageSender.sendStatusMessage("singleEnd", companyId, companyIds);
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Finished reindexing company ", companyId, " for class name ", className}));
                continue;
            }
            this.reindexStatusMessageSender.sendStatusMessage("singleEnd", companyId, companyIds);
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Finished reindexing company ", companyId, " for class name ", className}));
        }
    }

    private boolean _isSystemIndexer(Indexer<?> indexer) {
        if (this.systemIndexers.size() > 0) {
            for (Indexer systemIndexer : this.systemIndexers) {
                if (!indexer.equals((Object)systemIndexer)) continue;
                return true;
            }
        }
        return false;
    }
}

