/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.background.task;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.background.task.ReindexStatusMessageSenderUtil;
import com.liferay.portal.search.internal.SearchEngineInitializer;
import com.liferay.portal.search.internal.background.task.BaseReindexBackgroundTaskExecutor;
import org.osgi.framework.BundleContext;

public class ReindexPortalBackgroundTaskExecutor
extends BaseReindexBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(ReindexPortalBackgroundTaskExecutor.class);
    private final BundleContext _bundleContext;
    private final PortalExecutorManager _portalExecutorManager;

    public ReindexPortalBackgroundTaskExecutor(BundleContext bundleContext, PortalExecutorManager portalExecutorManager) {
        this._bundleContext = bundleContext;
        this._portalExecutorManager = portalExecutorManager;
    }

    public BackgroundTaskExecutor clone() {
        return new ReindexPortalBackgroundTaskExecutor(this._bundleContext, this._portalExecutorManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reindex(String className, long[] companyIds) throws Exception {
        for (long companyId : companyIds) {
            ReindexStatusMessageSenderUtil.sendStatusMessage((String)"portalStart", (long)companyId, (long[])companyIds);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Start reindexing company " + companyId));
            }
            try {
                SearchEngineInitializer searchEngineInitializer = new SearchEngineInitializer(this._bundleContext, companyId, this._portalExecutorManager);
                searchEngineInitializer.reindex();
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            finally {
                ReindexStatusMessageSenderUtil.sendStatusMessage((String)"portalEnd", (long)companyId, (long[])companyIds);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Finished reindexing company " + companyId));
                }
            }
        }
    }
}

