/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.background.task;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.search.internal.background.task.ReindexPortalBackgroundTaskExecutor;
import com.liferay.portal.search.internal.background.task.ReindexSingleIndexerBackgroundTaskExecutor;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BackgroundTaskExecutorConfigurator.class})
public class BackgroundTaskExecutorConfigurator {
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    @Reference
    private ReindexSingleIndexerBackgroundTaskExecutor _reindexSingleIndexerBackgroundTaskExecutor;
    private final Set<ServiceRegistration<BackgroundTaskExecutor>> _serviceRegistrations = new HashSet<ServiceRegistration<BackgroundTaskExecutor>>();

    @Activate
    protected void activate(BundleContext bundleContext) {
        ReindexPortalBackgroundTaskExecutor reindexPortalBackgroundTaskExecutor = new ReindexPortalBackgroundTaskExecutor(bundleContext, this._portalExecutorManager);
        this._registerBackgroundTaskExecutor(bundleContext, (BackgroundTaskExecutor)reindexPortalBackgroundTaskExecutor);
        this._registerBackgroundTaskExecutor(bundleContext, (BackgroundTaskExecutor)this._reindexSingleIndexerBackgroundTaskExecutor);
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<BackgroundTaskExecutor> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private void _registerBackgroundTaskExecutor(BundleContext bundleContext, BackgroundTaskExecutor backgroundTaskExecutor) {
        Class<?> clazz = backgroundTaskExecutor.getClass();
        ServiceRegistration serviceRegistration = bundleContext.registerService(BackgroundTaskExecutor.class, (Object)backgroundTaskExecutor, (Dictionary)HashMapDictionaryBuilder.put((Object)"background.task.executor.class.name", (Object)clazz.getName()).build());
        this._serviceRegistrations.add((ServiceRegistration<BackgroundTaskExecutor>)serviceRegistration);
    }
}

