/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.analysis;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.search.analysis.FieldQueryBuilder;
import com.liferay.portal.search.analysis.KeywordTokenizer;
import com.liferay.portal.search.configuration.TitleFieldQueryBuilderConfiguration;
import com.liferay.portal.search.internal.analysis.FullTextQueryBuilder;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.configuration.TitleFieldQueryBuilderConfiguration"}, immediate=true, service={TitleFieldQueryBuilder.class})
public class TitleFieldQueryBuilder
implements FieldQueryBuilder {
    @Reference
    protected KeywordTokenizer keywordTokenizer;
    private volatile float _exactMatchBoost = 2.0f;
    private volatile int _maxExpansions = 300;

    public Query build(String field, String keywords) {
        FullTextQueryBuilder fullTextQueryBuilder = new FullTextQueryBuilder(this.keywordTokenizer);
        fullTextQueryBuilder.setAutocomplete(true);
        fullTextQueryBuilder.setExactMatchBoost(this._exactMatchBoost);
        fullTextQueryBuilder.setMaxExpansions(this._maxExpansions);
        return fullTextQueryBuilder.build(field, keywords);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        TitleFieldQueryBuilderConfiguration titleFieldQueryBuilderConfiguration = (TitleFieldQueryBuilderConfiguration)ConfigurableUtil.createConfigurable(TitleFieldQueryBuilderConfiguration.class, properties);
        this._exactMatchBoost = titleFieldQueryBuilderConfiguration.exactMatchBoost();
        this._maxExpansions = titleFieldQueryBuilderConfiguration.maxExpansions();
    }
}

