/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.analysis;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryTerm;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.QueryTermImpl;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.analysis.FieldQueryBuilder;
import com.liferay.portal.search.analysis.KeywordTokenizer;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SubstringFieldQueryBuilder.class})
public class SubstringFieldQueryBuilder
implements FieldQueryBuilder {
    @Reference
    protected KeywordTokenizer keywordTokenizer;

    public Query build(String field, String keywords) {
        BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
        List tokens = this.keywordTokenizer.tokenize(keywords);
        for (String token : tokens) {
            booleanQueryImpl.add(this._createQuery(field, token), BooleanClauseOccur.SHOULD);
        }
        return booleanQueryImpl;
    }

    private Query _createQuery(String field, String value) {
        if (StringUtil.startsWith((String)value, (char)'\"')) {
            value = StringUtil.unquote((String)value);
        }
        value = (value = StringUtil.replace((String)value, (char)'%', (String)"")).isEmpty() ? "*" : StringUtil.quote((String)StringUtil.toLowerCase((String)value), (String)"*");
        return new WildcardQueryImpl((QueryTerm)new QueryTermImpl(field, value));
    }
}

