/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.aggregation.pipeline;

import com.liferay.portal.search.aggregation.pipeline.BucketSelectorPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.GapPolicy;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationVisitor;
import com.liferay.portal.search.internal.aggregation.pipeline.BasePipelineAggregation;
import com.liferay.portal.search.script.Script;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BucketSelectorPipelineAggregationImpl
extends BasePipelineAggregation
implements BucketSelectorPipelineAggregation {
    private final Map<String, String> _bucketsPathsMap = new HashMap<String, String>();
    private GapPolicy _gapPolicy;
    private final Script _script;

    public BucketSelectorPipelineAggregationImpl(String name, Script script) {
        super(name);
        this._script = script;
    }

    public BucketSelectorPipelineAggregationImpl(String name, Script script, Map<String, String> bucketsPathsMap) {
        super(name);
        this._script = script;
        this._bucketsPathsMap.putAll(bucketsPathsMap);
    }

    public <T> T accept(PipelineAggregationVisitor<T> pipelineAggregationVisitor) {
        return (T)pipelineAggregationVisitor.visit((BucketSelectorPipelineAggregation)this);
    }

    public void addBucketPath(String paramName, String bucketPath) {
        this._bucketsPathsMap.put(paramName, bucketPath);
    }

    public Map<String, String> getBucketsPathsMap() {
        return Collections.unmodifiableMap(this._bucketsPathsMap);
    }

    public GapPolicy getGapPolicy() {
        return this._gapPolicy;
    }

    public Script getScript() {
        return this._script;
    }

    public void setGapPolicy(GapPolicy gapPolicy) {
        this._gapPolicy = gapPolicy;
    }
}

