/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.aggregation.bucket;

import com.liferay.portal.search.aggregation.AggregationVisitor;
import com.liferay.portal.search.aggregation.bucket.Range;
import com.liferay.portal.search.aggregation.bucket.RangeAggregation;
import com.liferay.portal.search.internal.aggregation.BaseFieldAggregation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RangeAggregationImpl
extends BaseFieldAggregation
implements RangeAggregation {
    private String _format;
    private Boolean _keyed;
    private final List<Range> _ranges = new ArrayList<Range>();

    public RangeAggregationImpl(String name, String field) {
        super(name, field);
    }

    public <T> T accept(AggregationVisitor<T> aggregationVisitor) {
        return (T)aggregationVisitor.visit((RangeAggregation)this);
    }

    public void addRange(Range range) {
        this._ranges.add(range);
    }

    public void addRanges(Range ... ranges) {
        Collections.addAll(this._ranges, ranges);
    }

    public void addUnboundedFrom(Double from) {
        this.addRange(new Range(from, null));
    }

    public void addUnboundedFrom(String key, Double from) {
        this.addRange(new Range(key, from, null));
    }

    public void addUnboundedTo(Double to) {
        this.addRange(new Range(null, to));
    }

    public void addUnboundedTo(String key, Double to) {
        this.addRange(new Range(key, null, to));
    }

    public String getFormat() {
        return this._format;
    }

    public Boolean getKeyed() {
        return this._keyed;
    }

    public List<Range> getRanges() {
        return Collections.unmodifiableList(this._ranges);
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public void setKeyed(Boolean keyed) {
        this._keyed = keyed;
    }
}

