/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.aggregation.bucket;

import com.liferay.portal.search.aggregation.AggregationVisitor;
import com.liferay.portal.search.aggregation.bucket.GeoDistanceAggregation;
import com.liferay.portal.search.aggregation.bucket.Range;
import com.liferay.portal.search.geolocation.DistanceUnit;
import com.liferay.portal.search.geolocation.GeoDistance;
import com.liferay.portal.search.geolocation.GeoDistanceType;
import com.liferay.portal.search.geolocation.GeoLocationPoint;
import com.liferay.portal.search.internal.aggregation.BaseFieldAggregation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GeoDistanceAggregationImpl
extends BaseFieldAggregation
implements GeoDistanceAggregation {
    private DistanceUnit _distanceUnit;
    private GeoDistance _geoDistance;
    private GeoDistanceType _geoDistanceType;
    private GeoLocationPoint _geoLocationPoint;
    private Boolean _keyed;
    private final List<Range> _ranges = new ArrayList<Range>();

    public GeoDistanceAggregationImpl(String name, String field, GeoLocationPoint geoLocationPoint) {
        super(name, field);
        this._geoLocationPoint = geoLocationPoint;
    }

    public <T> T accept(AggregationVisitor<T> aggregationVisitor) {
        return (T)aggregationVisitor.visit((GeoDistanceAggregation)this);
    }

    public void addRange(Range range) {
        this._ranges.add(range);
    }

    public void addRanges(Range ... ranges) {
        Collections.addAll(this._ranges, ranges);
    }

    public void addUnboundedFrom(Double from) {
        this.addRange(new Range(from, null));
    }

    public void addUnboundedFrom(String key, Double from) {
        this.addRange(new Range(key, from, null));
    }

    public void addUnboundedTo(String key, Double to) {
        this.addRange(new Range(key, null, to));
    }

    public DistanceUnit getDistanceUnit() {
        return this._distanceUnit;
    }

    public GeoDistance getGeoDistance() {
        return this._geoDistance;
    }

    public GeoDistanceType getGeoDistanceType() {
        return this._geoDistanceType;
    }

    public GeoLocationPoint getGeoLocationPoint() {
        return this._geoLocationPoint;
    }

    public Boolean getKeyed() {
        return this._keyed;
    }

    public List<Range> getRanges() {
        return Collections.unmodifiableList(this._ranges);
    }

    public void setDistanceUnit(DistanceUnit distanceUnit) {
        this._distanceUnit = distanceUnit;
    }

    public void setGeoDistance(GeoDistance geoDistance) {
        this._geoDistance = geoDistance;
    }

    public void setGeoDistanceType(GeoDistanceType geoDistanceType) {
        this._geoDistanceType = geoDistanceType;
    }

    public void setGeoLocationPoint(GeoLocationPoint geoLocationPoint) {
        this._geoLocationPoint = geoLocationPoint;
    }

    public void setKeyed(Boolean keyed) {
        this._keyed = keyed;
    }
}

