/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.aggregation.bucket;

import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BucketImpl
implements Bucket {
    private final Map<String, AggregationResult> _childrenAggregationResults = new HashMap<String, AggregationResult>();
    private final long _docCount;
    private final String _key;

    public BucketImpl(String key, long docCount) {
        this._key = key;
        this._docCount = docCount;
    }

    public void addChildAggregationResult(AggregationResult aggregationResult) {
        this._childrenAggregationResults.put(aggregationResult.getName(), aggregationResult);
    }

    public void addChildrenAggregationResults(List<AggregationResult> aggregationResults) {
        aggregationResults.forEach(this::addChildAggregationResult);
    }

    public AggregationResult getChildAggregationResult(String name) {
        return this._childrenAggregationResults.get(name);
    }

    public Map<String, AggregationResult> getChildrenAggregationResults() {
        return Collections.unmodifiableMap(this._childrenAggregationResults);
    }

    public long getDocCount() {
        return this._docCount;
    }

    public String getKey() {
        return this._key;
    }

    public String toString() {
        return this._key + "=" + this._docCount;
    }
}

