/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.aggregation;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;

public abstract class BaseAggregation
implements Aggregation {
    private final Map<String, Aggregation> _childrenAggregations = new LinkedHashMap<String, Aggregation>();
    private final String _name;
    private final Map<String, PipelineAggregation> _pipelineAggregations = new LinkedHashMap<String, PipelineAggregation>();

    public BaseAggregation(String name) {
        this._name = name;
    }

    public void addChildAggregation(Aggregation aggregation) {
        this._childrenAggregations.put(aggregation.getName(), aggregation);
    }

    public void addChildrenAggregations(Aggregation ... aggregations) {
        Stream.of(aggregations).forEach(this::addChildAggregation);
    }

    public void addPipelineAggregation(PipelineAggregation pipelineAggregation) {
        this._pipelineAggregations.put(pipelineAggregation.getName(), pipelineAggregation);
    }

    public void addPipelineAggregations(PipelineAggregation ... pipelineAggregations) {
        Stream.of(pipelineAggregations).forEach(this::addPipelineAggregation);
    }

    public Aggregation getChildAggregation(String name) {
        return this._childrenAggregations.get(name);
    }

    public Collection<Aggregation> getChildrenAggregations() {
        return Collections.unmodifiableCollection(this._childrenAggregations.values());
    }

    public String getName() {
        return this._name;
    }

    public PipelineAggregation getPipelineAggregation(String name) {
        return this._pipelineAggregations.get(name);
    }

    public Collection<PipelineAggregation> getPipelineAggregations() {
        return Collections.unmodifiableCollection(this._pipelineAggregations.values());
    }

    public void removeChildAggregation(Aggregation aggregation) {
        this._childrenAggregations.remove(aggregation.getName());
    }

    public void removePipelineAggregation(PipelineAggregation pipelineAggregation) {
        this._pipelineAggregations.remove(pipelineAggregation.getName());
    }
}

