/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.NoSuchResourceException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.configuration.SearchPermissionCheckerConfiguration;
import com.liferay.portal.search.spi.model.permission.SearchPermissionFieldContributor;
import com.liferay.portal.search.spi.model.permission.SearchPermissionFilterContributor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.search.configuration.SearchPermissionCheckerConfiguration"}, immediate=true, service={SearchPermissionChecker.class})
public class SearchPermissionCheckerImpl
implements SearchPermissionChecker {
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected IndexerRegistry indexerRegistry;
    protected PermissionChecker permissionChecker;
    @Reference
    protected PermissionCheckerFactory permissionCheckerFactory;
    @Reference
    protected Portal portal;
    @Reference
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    @Reference
    protected RoleLocalService roleLocalService;
    protected volatile SearchPermissionCheckerConfiguration searchPermissionCheckerConfiguration;
    @Reference
    protected UserLocalService userLocalService;
    private static final String _NULL_SEARCH_PERMISSION_CONTEXT = "";
    private static final Log _log = LogFactoryUtil.getLog(SearchPermissionCheckerImpl.class);
    private final Collection<SearchPermissionFieldContributor> _searchPermissionFieldContributors = new CopyOnWriteArrayList<SearchPermissionFieldContributor>();
    private final Collection<SearchPermissionFilterContributor> _searchPermissionFilterContributors = new CopyOnWriteArrayList<SearchPermissionFilterContributor>();

    public void addPermissionFields(long companyId, Document document) {
        try {
            boolean relatedEntry;
            long groupId = GetterUtil.getLong((String)document.get("groupId"));
            String className = document.get("entryClassName");
            String classPK = document.get("entryClassPK");
            if (Validator.isNull((String)className) && Validator.isNull((String)classPK)) {
                className = document.get("rootEntryClassName");
                classPK = document.get("rootEntryClassPK");
            }
            if (relatedEntry = GetterUtil.getBoolean((String)document.get("relatedEntry"))) {
                long classNameId = GetterUtil.getLong((String)document.get("classNameId"));
                if (classNameId == 0L) {
                    return;
                }
                className = this.portal.getClassName(classNameId);
                classPK = document.get("classPK");
            }
            if (Validator.isNull((String)className) || Validator.isNull((String)classPK)) {
                return;
            }
            Indexer indexer = this.indexerRegistry.nullSafeGetIndexer(className);
            if (!indexer.isPermissionAware()) {
                return;
            }
            String viewActionId = document.get("viewActionId");
            if (Validator.isNull((String)viewActionId)) {
                viewActionId = "VIEW";
            }
            this._addPermissionFields(companyId, groupId, className, GetterUtil.getLong((String)classPK), viewActionId, document);
        }
        catch (NoSuchResourceException noSuchResourceException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchResourceException);
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public BooleanFilter getPermissionBooleanFilter(long companyId, long[] groupIds, long userId, String className, BooleanFilter booleanFilter, SearchContext searchContext) {
        try {
            return this._getPermissionBooleanFilter(companyId, groupIds, userId, className, booleanFilter, searchContext);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return booleanFilter;
        }
    }

    public void updatePermissionFields(String resourceName, String resourceClassPK) {
        try {
            Indexer indexer = this.indexerRegistry.nullSafeGetIndexer(resourceName);
            indexer.reindex(resourceName, GetterUtil.getLong((String)resourceClassPK));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this.searchPermissionCheckerConfiguration = (SearchPermissionCheckerConfiguration)ConfigurableUtil.createConfigurable(SearchPermissionCheckerConfiguration.class, properties);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addSearchPermissionFieldContributor(SearchPermissionFieldContributor searchPermissionFieldContributor) {
        this._searchPermissionFieldContributors.add(searchPermissionFieldContributor);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addSearchPermissionFilterContributor(SearchPermissionFilterContributor searchPermissionFilterContributor) {
        this._searchPermissionFilterContributors.add(searchPermissionFilterContributor);
    }

    protected void removeSearchPermissionFieldContributor(SearchPermissionFieldContributor searchPermissionFieldContributor) {
        this._searchPermissionFieldContributors.remove(searchPermissionFieldContributor);
    }

    protected void removeSearchPermissionFilterContributor(SearchPermissionFilterContributor searchPermissionFilterContributor) {
        this._searchPermissionFilterContributors.remove(searchPermissionFilterContributor);
    }

    private void _add(BooleanFilter booleanFilter, TermsFilter termsFilter) {
        if (!termsFilter.isEmpty()) {
            booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.SHOULD);
        }
    }

    private void _addGroup(Group group, List<Role> groupRoles, List<UsersGroupIdRoles> usersGroupIdsRoles) {
        if (group != null) {
            usersGroupIdsRoles.add(new UsersGroupIdRoles(group.getGroupId(), groupRoles));
        }
    }

    private void _addPermissionFields(long companyId, long groupId, String className, long classPK, String viewActionId, Document document) throws Exception {
        for (SearchPermissionFieldContributor searchPermissionFieldContributor : this._searchPermissionFieldContributors) {
            searchPermissionFieldContributor.contribute(document, className, classPK);
        }
        List roles = this.resourcePermissionLocalService.getRoles(companyId, className, 4, String.valueOf(classPK), viewActionId);
        if (roles.isEmpty()) {
            return;
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        ArrayList<String> groupRoleIds = new ArrayList<String>();
        for (Role role : roles) {
            if (role.getType() == 3 || role.getType() == 2) {
                groupRoleIds.add(groupId + "-" + role.getRoleId());
                continue;
            }
            roleIds.add(role.getRoleId());
        }
        document.addKeyword("roleId", roleIds.toArray(new Long[0]));
        document.addKeyword("groupRoleId", groupRoleIds.toArray(new String[0]));
    }

    private SearchPermissionContext _createSearchPermissionContext(long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker) throws Exception {
        UserBag userBag = permissionChecker.getUserBag();
        if (userBag == null) {
            return null;
        }
        HashSet<Role> roles = new HashSet<Role>();
        if (permissionChecker.isSignedIn() && ArrayUtil.isNotEmpty((long[])groupIds)) {
            for (long groupId : groupIds) {
                for (Role role : this.roleLocalService.getRoles(permissionChecker.getRoleIds(userId, groupId))) {
                    if (role.getType() != 1) continue;
                    roles.add(role);
                }
            }
        } else {
            roles.addAll(this.roleLocalService.getRoles(permissionChecker.getRoleIds(userId, 0L)));
        }
        int termsCount = roles.size();
        int permissionTermsLimit = this.searchPermissionCheckerConfiguration.permissionTermsLimit();
        if (termsCount > permissionTermsLimit) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping presearch permission checking due to too ", "many roles: ", termsCount, " > ", permissionTermsLimit}));
            }
            return null;
        }
        Collection groups = userBag.getGroups();
        ArrayList<UsersGroupIdRoles> usersGroupIdsRoles = new ArrayList<UsersGroupIdRoles>(groups.size());
        if ((termsCount += groups.size()) > permissionTermsLimit) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping presearch permission checking due to too ", "many roles and groups: ", termsCount, " > ", permissionTermsLimit}));
            }
            return null;
        }
        Role organizationUserRole = this.roleLocalService.getRole(companyId, "Organization User");
        Role siteMemberRole = this.roleLocalService.getRole(companyId, "Site Member");
        for (Group group : groups) {
            List groupRoles = this.roleLocalService.getRoles(permissionChecker.getRoleIds(userId, group.getGroupId()));
            roles.addAll(groupRoles);
            Iterator iterator = groupRoles.iterator();
            while (iterator.hasNext()) {
                Role groupRole = (Role)iterator.next();
                if (groupRole.getType() == 3 || groupRole.getType() == 2) continue;
                iterator.remove();
            }
            if (group.isOrganization() && !groupRoles.contains(organizationUserRole)) {
                groupRoles.add(organizationUserRole);
            }
            if (group.isSite() && !groupRoles.contains(siteMemberRole)) {
                groupRoles.add(siteMemberRole);
            }
            this._addGroup(group, groupRoles, usersGroupIdsRoles);
            this._addGroup(group.getStagingGroup(), groupRoles, usersGroupIdsRoles);
            if ((termsCount += groupRoles.size()) <= permissionTermsLimit) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping presearch permission checking due to ", "too many roles, groups, and group roles: ", termsCount, " > ", permissionTermsLimit}));
            }
            return null;
        }
        return new SearchPermissionContext(roles, usersGroupIdsRoles);
    }

    private BooleanFilter _getPermissionBooleanFilter(long companyId, long[] groupIds, long userId, String className, BooleanFilter booleanFilter, SearchContext searchContext) throws Exception {
        BooleanFilter permissionBooleanFilter = this._getPermissionBooleanFilter(companyId, groupIds, userId, className, searchContext);
        if (booleanFilter == null) {
            return permissionBooleanFilter;
        }
        if (permissionBooleanFilter != null) {
            booleanFilter.add((Filter)permissionBooleanFilter, BooleanClauseOccur.MUST);
        }
        return booleanFilter;
    }

    private BooleanFilter _getPermissionBooleanFilter(long companyId, long[] groupIds, long userId, String className, SearchContext searchContext) throws Exception {
        Indexer indexer = this.indexerRegistry.getIndexer(className);
        if (!indexer.isPermissionAware()) {
            return null;
        }
        PermissionChecker permissionChecker = this._getPermissionChecker();
        User user = permissionChecker.getUser();
        if (user == null || user.getUserId() != userId) {
            user = this.userLocalService.fetchUser(userId);
            if (user == null) {
                return null;
            }
            permissionChecker = this.permissionCheckerFactory.create(user);
        }
        Serializable searchPermissionContextObject = searchContext.getAttribute("searchPermissionContext");
        SearchPermissionContext searchPermissionContext = null;
        if (searchPermissionContextObject != null) {
            if (searchPermissionContextObject == _NULL_SEARCH_PERMISSION_CONTEXT) {
                return null;
            }
            searchPermissionContext = (SearchPermissionContext)searchPermissionContextObject;
        } else if (!permissionChecker.isCompanyAdmin(companyId)) {
            searchPermissionContext = this._createSearchPermissionContext(companyId, groupIds, userId, permissionChecker);
        }
        if (searchPermissionContext == null) {
            searchContext.setAttribute("searchPermissionContext", (Serializable)((Object)_NULL_SEARCH_PERMISSION_CONTEXT));
            return null;
        }
        searchContext.setAttribute("searchPermissionContext", (Serializable)searchPermissionContext);
        return this._getPermissionFilter(companyId, groupIds, userId, permissionChecker, this._getPermissionName(searchContext, className), searchPermissionContext);
    }

    private PermissionChecker _getPermissionChecker() {
        if (this.permissionChecker != null) {
            return this.permissionChecker;
        }
        return PermissionThreadLocal.getPermissionChecker();
    }

    private BooleanFilter _getPermissionFilter(long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker, String className, SearchPermissionContext searchPermissionContext) throws Exception {
        List usersGroupIdsRoles = searchPermissionContext._usersGroupIdsRoles;
        BooleanFilter booleanFilter = new BooleanFilter();
        if (userId > 0L) {
            booleanFilter.add((Filter)new TermFilter("userId", String.valueOf(userId)), BooleanClauseOccur.SHOULD);
        }
        TermsFilter groupRolesTermsFilter = searchPermissionContext._groupRolesTermsFilter;
        TermsFilter rolesTermsFilter = searchPermissionContext._rolesTermsFilter;
        long[] roleIds = searchPermissionContext._roleIds;
        if (this.resourcePermissionLocalService.hasResourcePermission(companyId, className, 1, String.valueOf(companyId), roleIds, "VIEW")) {
            return null;
        }
        long[] regularRoleIds = searchPermissionContext._regularRoleIds;
        if (this.resourcePermissionLocalService.hasResourcePermission(companyId, className, 3, String.valueOf(0L), regularRoleIds, "VIEW")) {
            return null;
        }
        TermsFilter groupsTermsFilter = new TermsFilter("groupId");
        for (UsersGroupIdRoles usersGroupIdRoles : usersGroupIdsRoles) {
            long groupId = usersGroupIdRoles._groupId;
            List groupRoles = usersGroupIdRoles._groupRoles;
            if (!permissionChecker.isGroupAdmin(groupId) && !this.resourcePermissionLocalService.hasResourcePermission(companyId, className, 2, String.valueOf(groupId), roleIds, "VIEW") && !this.resourcePermissionLocalService.hasResourcePermission(companyId, className, 3, String.valueOf(0L), ListUtil.toLongArray((List)groupRoles, (Accessor)Role.ROLE_ID_ACCESSOR), "VIEW")) continue;
            groupsTermsFilter.addValue(String.valueOf(groupId));
        }
        if (ArrayUtil.isNotEmpty((long[])groupIds)) {
            for (Object searchGroupId : (Iterator<SearchPermissionFilterContributor>)groupIds) {
                if (searchPermissionContext.containsGroupId((long)searchGroupId) || !this.resourcePermissionLocalService.hasResourcePermission(companyId, className, 2, String.valueOf((long)searchGroupId), roleIds, "VIEW")) continue;
                groupsTermsFilter.addValue(String.valueOf((long)searchGroupId));
            }
        }
        this._add(booleanFilter, groupRolesTermsFilter);
        this._add(booleanFilter, groupsTermsFilter);
        this._add(booleanFilter, rolesTermsFilter);
        for (SearchPermissionFilterContributor searchPermissionFilterContributor : this._searchPermissionFilterContributors) {
            searchPermissionFilterContributor.contribute(booleanFilter, companyId, groupIds, userId, permissionChecker, className);
        }
        if (!booleanFilter.hasClauses()) {
            return null;
        }
        return booleanFilter;
    }

    private String _getPermissionName(SearchContext searchContext, String defaultValue) {
        return GetterUtil.getString((Object)searchContext.getAttribute("resourcePermissionName"), (String)defaultValue);
    }

    private static class UsersGroupIdRoles
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long _groupId;
        private final List<Role> _groupRoles;

        private UsersGroupIdRoles(long groupId, List<Role> groupRoles) {
            this._groupId = groupId;
            this._groupRoles = groupRoles;
        }
    }

    private static class SearchPermissionContext
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final TermsFilter _groupRolesTermsFilter = new TermsFilter("groupRoleId");
        private final long[] _regularRoleIds;
        private final long[] _roleIds;
        private final TermsFilter _rolesTermsFilter = new TermsFilter("roleId");
        private final List<UsersGroupIdRoles> _usersGroupIdsRoles;

        public boolean containsGroupId(long groupId) {
            for (UsersGroupIdRoles usersGroupIdRoles : this._usersGroupIdsRoles) {
                if (groupId != usersGroupIdRoles._groupId) continue;
                return true;
            }
            return false;
        }

        private SearchPermissionContext(Set<Role> roles, List<UsersGroupIdRoles> usersGroupIdsRoles) {
            this._usersGroupIdsRoles = usersGroupIdsRoles;
            ArrayList<Long> roleIds = new ArrayList<Long>(roles.size());
            ArrayList<Long> regularRoleIds = new ArrayList<Long>();
            for (Role role : roles) {
                roleIds.add(role.getRoleId());
                if (role.getType() == 1) {
                    regularRoleIds.add(role.getRoleId());
                }
                this._rolesTermsFilter.addValue(String.valueOf(role.getRoleId()));
            }
            this._roleIds = ArrayUtil.toLongArray(roleIds);
            this._regularRoleIds = ArrayUtil.toLongArray(regularRoleIds);
            for (UsersGroupIdRoles usersGroupIdRoles : this._usersGroupIdsRoles) {
                long groupId = usersGroupIdRoles._groupId;
                List groupRoles = usersGroupIdRoles._groupRoles;
                for (Role groupRole : groupRoles) {
                    this._groupRolesTermsFilter.addValue(groupId + "-" + groupRole.getRoleId());
                }
            }
        }
    }
}

