/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.search.configuration.SearchEngineHelperConfiguration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.search.configuration.SearchEngineHelperConfiguration"}, service={SearchEngineHelper.class})
public class SearchEngineHelperImpl
implements SearchEngineHelper {
    private final Set<String> _excludedEntryClassNames = Collections.newSetFromMap(new ConcurrentHashMap());
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile SearchEngine _searchEngine;

    public String[] getEntryClassNames() {
        HashSet<String> assetEntryClassNames = new HashSet<String>();
        for (Indexer indexer : IndexerRegistryUtil.getIndexers()) {
            for (String className : indexer.getSearchClassNames()) {
                if (this._excludedEntryClassNames.contains(className)) continue;
                assetEntryClassNames.add(className);
            }
        }
        return assetEntryClassNames.toArray(new String[0]);
    }

    public SearchEngine getSearchEngine() {
        return this._searchEngine;
    }

    public void initialize(long companyId) {
        this._searchEngine.initialize(companyId);
    }

    public void removeCompany(long companyId) {
        this._searchEngine.removeCompany(companyId);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        SearchEngineHelperConfiguration searchEngineHelperConfiguration = (SearchEngineHelperConfiguration)ConfigurableUtil.createConfigurable(SearchEngineHelperConfiguration.class, properties);
        this._excludedEntryClassNames.clear();
        Collections.addAll(this._excludedEntryClassNames, searchEngineHelperConfiguration.excludedEntryClassNames());
    }
}

