/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.osgi.util.StringPlus;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.dummy.DummyIndexer;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.search.configuration.IndexerRegistryConfiguration;
import com.liferay.portal.search.index.IndexStatusManager;
import com.liferay.portal.search.internal.buffer.BufferedIndexerInvocationHandler;
import com.liferay.portal.search.internal.buffer.IndexerRequestBuffer;
import com.liferay.portal.search.internal.buffer.IndexerRequestBufferOverflowHandler;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ClassUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"com.liferay.portal.search.configuration.IndexerRegistryConfiguration"}, immediate=true, service={IndexerRegistry.class})
public class IndexerRegistryImpl
implements IndexerRegistry {
    private static final Log _log = LogFactoryUtil.getLog(IndexerRegistryImpl.class);
    private final Map<String, BufferedIndexerInvocationHandler> _bufferedInvocationHandlers = new ConcurrentHashMap<String, BufferedIndexerInvocationHandler>();
    @Reference(target="(mode=DEFAULT)")
    private IndexerRequestBufferOverflowHandler _defaultIndexerRequestBufferOverflowHandler;
    private final Indexer<?> _dummyIndexer = new DummyIndexer();
    private volatile IndexerRegistryConfiguration _indexerRegistryConfiguration;
    private volatile IndexerRequestBufferOverflowHandler _indexerRequestBufferOverflowHandler;
    private final Map<String, Indexer<? extends Object>> _indexers = new ConcurrentHashMap<String, Indexer<? extends Object>>();
    private ServiceTracker<Indexer<?>, Indexer<?>> _indexerServiceTracker;
    @Reference
    private IndexStatusManager _indexStatusManager;
    @Reference
    private PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    private final Map<String, Indexer<? extends Object>> _proxiedIndexers = new ConcurrentHashMap<String, Indexer<? extends Object>>();
    private final Map<String, List<IndexerPostProcessor>> _queuedIndexerPostProcessors = new HashMap<String, List<IndexerPostProcessor>>();

    public <T> Indexer<T> getIndexer(Class<T> clazz) {
        return this.getIndexer(clazz.getName());
    }

    public <T> Indexer<T> getIndexer(String className) {
        Indexer<? extends Object> indexer = this._indexers.get(className);
        return this._proxyIndexer(indexer);
    }

    public Set<Indexer<?>> getIndexers() {
        return new HashSet(this._indexers.values());
    }

    public <T> Indexer<T> nullSafeGetIndexer(Class<T> clazz) {
        return this.nullSafeGetIndexer(clazz.getName());
    }

    public <T> Indexer<T> nullSafeGetIndexer(String className) {
        Indexer<T> indexer = this.getIndexer(className);
        if (indexer != null) {
            return indexer;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("No indexer found for " + className));
        }
        return this._dummyIndexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Indexer<?> indexer) {
        Class<?> clazz = indexer.getClass();
        this._indexers.put(clazz.getName(), indexer);
        this._indexers.put(indexer.getClassName(), indexer);
        Map<String, List<IndexerPostProcessor>> map = this._queuedIndexerPostProcessors;
        synchronized (map) {
            List indexerPostProcessors = this._queuedIndexerPostProcessors.getOrDefault(clazz.getName(), new ArrayList());
            Optional.ofNullable(this._queuedIndexerPostProcessors.get(indexer.getClassName())).ifPresent(indexerPostProcessors::addAll);
            indexerPostProcessors.forEach(arg_0 -> indexer.registerIndexerPostProcessor(arg_0));
            this._queuedIndexerPostProcessors.remove(clazz.getName());
            this._queuedIndexerPostProcessors.remove(indexer.getClassName());
        }
    }

    public void unregister(Indexer<?> indexer) {
        Class<?> clazz = indexer.getClass();
        this.unregister(clazz.getName());
        this.unregister(indexer.getClassName());
    }

    public void unregister(String className) {
        this._bufferedInvocationHandlers.remove(className);
        this._indexers.remove(className);
        this._proxiedIndexers.remove(className);
    }

    @Activate
    protected void activate(final BundleContext bundleContext, Map<String, Object> properties) {
        this.modified(properties);
        this._indexerServiceTracker = new ServiceTracker(bundleContext, Indexer.class.getName(), new ServiceTrackerCustomizer<Indexer<?>, Indexer<?>>(){

            public Indexer<?> addingService(ServiceReference<Indexer<?>> serviceReference) {
                Indexer indexer = (Indexer)bundleContext.getService(serviceReference);
                IndexerRegistryImpl.this.register(indexer);
                return indexer;
            }

            public void modifiedService(ServiceReference<Indexer<?>> serviceReference, Indexer<?> indexer) {
            }

            public void removedService(ServiceReference<Indexer<?>> serviceReference, Indexer<?> indexer) {
                IndexerRegistryImpl.this.unregister(indexer);
                bundleContext.ungetService(serviceReference);
            }
        });
        this._indexerServiceTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(indexer.class.name=*)")
    protected void addIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor, Map<String, Object> properties) {
        List indexerClassNames = StringPlus.asList((Object)properties.get("indexer.class.name"));
        for (String indexerClassName : indexerClassNames) {
            Indexer indexer = this.getIndexer(indexerClassName);
            if (indexer != null) {
                indexer.registerIndexerPostProcessor(indexerPostProcessor);
                continue;
            }
            Map<String, List<IndexerPostProcessor>> map = this._queuedIndexerPostProcessors;
            synchronized (map) {
                List indexerPostProcessors = this._queuedIndexerPostProcessors.computeIfAbsent(indexerClassName, key -> new ArrayList());
                indexerPostProcessors.add(indexerPostProcessor);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Registration of indexer post processor for ", indexerClassName, " will be completed once the indexer becomes ", "available"}));
                }
            }
        }
    }

    @Deactivate
    protected void deactivate() {
        this._indexerServiceTracker.close();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this._indexerRegistryConfiguration = (IndexerRegistryConfiguration)ConfigurableUtil.createConfigurable(IndexerRegistryConfiguration.class, properties);
        for (BufferedIndexerInvocationHandler bufferedIndexerInvocationHandler : this._bufferedInvocationHandlers.values()) {
            bufferedIndexerInvocationHandler.setIndexerRegistryConfiguration(this._indexerRegistryConfiguration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor, Map<String, Object> properties) {
        List indexerClassNames = StringPlus.asList((Object)properties.get("indexer.class.name"));
        for (String indexerClassName : indexerClassNames) {
            Indexer indexer = this.getIndexer(indexerClassName);
            if (indexer == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("No indexer exists for " + indexerClassName));
                }
            } else {
                indexer.unregisterIndexerPostProcessor(indexerPostProcessor);
            }
            Map<String, List<IndexerPostProcessor>> map = this._queuedIndexerPostProcessors;
            synchronized (map) {
                List<IndexerPostProcessor> indexerPostProcessors = this._queuedIndexerPostProcessors.get(indexerClassName);
                if (indexerPostProcessors != null) {
                    indexerPostProcessors.remove(indexerPostProcessor);
                    if (indexerPostProcessors.isEmpty()) {
                        this._queuedIndexerPostProcessors.remove(indexerClassName);
                    }
                }
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setIndexerRequestBufferOverflowHandler(IndexerRequestBufferOverflowHandler indexerRequestBufferOverflowHandler) {
        this._indexerRequestBufferOverflowHandler = indexerRequestBufferOverflowHandler;
        for (BufferedIndexerInvocationHandler bufferedIndexerInvocationHandler : this._bufferedInvocationHandlers.values()) {
            bufferedIndexerInvocationHandler.setIndexerRequestBufferOverflowHandler(this._indexerRequestBufferOverflowHandler);
        }
    }

    protected void unsetIndexerRequestBufferOverflowHandler(IndexerRequestBufferOverflowHandler indexerRequestBufferOverflowHandler) {
        this._indexerRequestBufferOverflowHandler = null;
        for (BufferedIndexerInvocationHandler bufferedIndexerInvocationHandler : this._bufferedInvocationHandlers.values()) {
            bufferedIndexerInvocationHandler.setIndexerRequestBufferOverflowHandler(this._defaultIndexerRequestBufferOverflowHandler);
        }
    }

    private <T> Indexer<T> _proxyIndexer(Indexer<T> indexer) {
        if (indexer == null) {
            return null;
        }
        IndexerRequestBuffer indexerRequestBuffer = IndexerRequestBuffer.get();
        if (indexerRequestBuffer == null || !this._indexerRegistryConfiguration.buffered()) {
            return indexer;
        }
        Indexer proxiedIndexer = this._proxiedIndexers.get(indexer.getClassName());
        if (proxiedIndexer == null) {
            List interfaces = ClassUtils.getAllInterfaces(indexer.getClass());
            BufferedIndexerInvocationHandler bufferedIndexerInvocationHandler = new BufferedIndexerInvocationHandler(indexer, this._indexStatusManager, this._indexerRegistryConfiguration, this._persistedModelLocalServiceRegistry);
            if (this._indexerRequestBufferOverflowHandler == null) {
                bufferedIndexerInvocationHandler.setIndexerRequestBufferOverflowHandler(this._defaultIndexerRequestBufferOverflowHandler);
            } else {
                bufferedIndexerInvocationHandler.setIndexerRequestBufferOverflowHandler(this._indexerRequestBufferOverflowHandler);
            }
            this._bufferedInvocationHandlers.put(indexer.getClassName(), bufferedIndexerInvocationHandler);
            proxiedIndexer = (Indexer)ProxyUtil.newProxyInstance((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (Class[])interfaces.toArray(new Class[0]), (InvocationHandler)bufferedIndexerInvocationHandler);
            this._proxiedIndexers.put(indexer.getClassName(), (Indexer<? extends Object>)proxiedIndexer);
        }
        return proxiedIndexer;
    }
}

