/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.configuration.IndexWriterHelperConfiguration;
import com.liferay.portal.search.index.IndexStatusManager;
import com.liferay.portal.search.internal.background.task.ReindexPortalBackgroundTaskExecutor;
import com.liferay.portal.search.internal.background.task.ReindexSingleIndexerBackgroundTaskExecutor;
import com.liferay.portal.search.model.uid.UIDFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.configuration.IndexWriterHelperConfiguration"}, immediate=true, service={IndexWriterHelper.class})
public class IndexWriterHelperImpl
implements IndexWriterHelper {
    @Reference
    protected UIDFactory uidFactory;
    private static final Log _log = LogFactoryUtil.getLog(IndexWriterHelperImpl.class);
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    private volatile boolean _commitImmediately;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private IndexStatusManager _indexStatusManager;
    @Reference
    private SearchEngineHelper _searchEngineHelper;
    @Reference
    private SearchPermissionChecker _searchPermissionChecker;

    public void addDocument(long companyId, Document document, boolean commitImmediately) throws SearchException {
        this._enforceStandardUID(document);
        if (this._indexStatusManager.isIndexReadOnly() || document == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Add document " + document.toString()));
        }
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        this._searchPermissionChecker.addPermissionFields(companyId, document);
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        this._setCommitImmediately(searchContext, commitImmediately);
        indexWriter.addDocument(searchContext, document);
    }

    public void addDocuments(long companyId, Collection<Document> documents, boolean commitImmediately) throws SearchException {
        this._enforceStandardUID(documents);
        if (this._indexStatusManager.isIndexReadOnly() || documents == null || documents.isEmpty()) {
            return;
        }
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        for (Document document : documents) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Add document " + document.toString()));
            }
            this._searchPermissionChecker.addPermissionFields(companyId, document);
        }
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        this._setCommitImmediately(searchContext, commitImmediately);
        indexWriter.addDocuments(searchContext, documents);
    }

    public void commit() throws SearchException {
        for (Company company : this._companyLocalService.getCompanies()) {
            this.commit(company.getCompanyId());
        }
    }

    public void commit(long companyId) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        indexWriter.commit(searchContext);
    }

    public void deleteDocument(long companyId, String uid, boolean commitImmediately) throws SearchException {
        if (this._indexStatusManager.isIndexReadOnly()) {
            return;
        }
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        this._setCommitImmediately(searchContext, commitImmediately);
        indexWriter.deleteDocument(searchContext, uid);
    }

    public void deleteDocuments(long companyId, Collection<String> uids, boolean commitImmediately) throws SearchException {
        if (this._indexStatusManager.isIndexReadOnly() || uids == null || uids.isEmpty()) {
            return;
        }
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        this._setCommitImmediately(searchContext, commitImmediately);
        indexWriter.deleteDocuments(searchContext, uids);
    }

    public void deleteEntityDocuments(long companyId, String className, boolean commitImmediately) throws SearchException {
        if (this._indexStatusManager.isIndexReadOnly()) {
            return;
        }
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        if (searchEngine == null) {
            return;
        }
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        this._setCommitImmediately(searchContext, commitImmediately);
        indexWriter.deleteEntityDocuments(searchContext, className);
    }

    public int getReindexTaskCount(long groupId, boolean completed) throws SearchException {
        return this._backgroundTaskManager.getBackgroundTasksCount(groupId, new String[]{ReindexPortalBackgroundTaskExecutor.class.getName(), ReindexSingleIndexerBackgroundTaskExecutor.class.getName()}, completed);
    }

    public void indexKeyword(long companyId, String querySuggestion, float weight, String keywordType, Locale locale) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setKeywords(querySuggestion);
        searchContext.setLocale(locale);
        indexWriter.indexKeyword(searchContext, weight, keywordType);
    }

    public void indexQuerySuggestionDictionaries(long companyId) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        indexWriter.indexQuerySuggestionDictionaries(searchContext);
    }

    public void indexQuerySuggestionDictionary(long companyId, Locale locale) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setLocale(locale);
        indexWriter.indexQuerySuggestionDictionary(searchContext);
    }

    public void indexSpellCheckerDictionaries(long companyId) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        indexWriter.indexSpellCheckerDictionaries(searchContext);
    }

    public void indexSpellCheckerDictionary(long companyId, Locale locale) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setLocale(locale);
        indexWriter.indexSpellCheckerDictionary(searchContext);
    }

    @Deprecated
    public boolean isIndexReadOnly() {
        return this._indexStatusManager.isIndexReadOnly();
    }

    @Deprecated
    public boolean isIndexReadOnly(String className) {
        return this._indexStatusManager.isIndexReadOnly(className);
    }

    public void partiallyUpdateDocument(long companyId, Document document, boolean commitImmediately) throws SearchException {
        this._enforceStandardUID(document);
        if (this._indexStatusManager.isIndexReadOnly() || document == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + document.toString()));
        }
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        this._searchPermissionChecker.addPermissionFields(companyId, document);
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        this._setCommitImmediately(searchContext, commitImmediately);
        indexWriter.partiallyUpdateDocument(searchContext, document);
    }

    public void partiallyUpdateDocuments(long companyId, Collection<Document> documents, boolean commitImmediately) throws SearchException {
        this._enforceStandardUID(documents);
        if (this._indexStatusManager.isIndexReadOnly() || documents == null || documents.isEmpty()) {
            return;
        }
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        for (Document document : documents) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Document " + document.toString()));
            }
            this._searchPermissionChecker.addPermissionFields(companyId, document);
        }
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        this._setCommitImmediately(searchContext, commitImmediately);
        indexWriter.partiallyUpdateDocuments(searchContext, documents);
    }

    public BackgroundTask reindex(long userId, String jobName, long[] companyIds, Map<String, Serializable> taskContextMap) throws SearchException {
        if (taskContextMap == null) {
            taskContextMap = new HashMap<String, Serializable>();
        }
        taskContextMap.put("deleteOnSuccess", Boolean.valueOf(true));
        taskContextMap.put("companyIds", (Serializable)companyIds);
        try {
            return this._backgroundTaskManager.addBackgroundTask(userId, 0L, jobName, ReindexPortalBackgroundTaskExecutor.class.getName(), taskContextMap, new ServiceContext());
        }
        catch (PortalException portalException) {
            throw new SearchException("Unable to schedule portal reindex", (Throwable)portalException);
        }
    }

    public BackgroundTask reindex(long userId, String jobName, long[] companyIds, String className, Map<String, Serializable> taskContextMap) throws SearchException {
        if (Validator.isNull((String)className)) {
            return this.reindex(userId, jobName, companyIds, taskContextMap);
        }
        if (taskContextMap == null) {
            taskContextMap = new HashMap<String, Serializable>();
        }
        taskContextMap.put("deleteOnSuccess", Boolean.valueOf(true));
        taskContextMap.put("className", (Serializable)((Object)className));
        taskContextMap.put("companyIds", (Serializable)companyIds);
        try {
            return this._backgroundTaskManager.addBackgroundTask(userId, 0L, jobName, ReindexSingleIndexerBackgroundTaskExecutor.class.getName(), taskContextMap, new ServiceContext());
        }
        catch (PortalException portalException) {
            throw new SearchException("Unable to schedule portal reindex", (Throwable)portalException);
        }
    }

    @Deprecated
    public void setIndexReadOnly(boolean indexReadOnly) {
        this._indexStatusManager.setIndexReadOnly(indexReadOnly);
    }

    @Deprecated
    public void setIndexReadOnly(String className, boolean indexReadOnly) {
        this._indexStatusManager.setIndexReadOnly(className, indexReadOnly);
    }

    public void updateDocument(long companyId, Document document) throws SearchException {
        this._enforceStandardUID(document);
        if (this._indexStatusManager.isIndexReadOnly() || document == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + document.toString()));
        }
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        this._searchPermissionChecker.addPermissionFields(companyId, document);
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        this._setCommitImmediately(searchContext, true);
        indexWriter.updateDocument(searchContext, document);
    }

    public void updateDocuments(long companyId, Collection<Document> documents, boolean commitImmediately) throws SearchException {
        this._enforceStandardUID(documents);
        if (this._indexStatusManager.isIndexReadOnly() || documents == null || documents.isEmpty()) {
            return;
        }
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        for (Document document : documents) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Document " + document.toString()));
            }
            this._searchPermissionChecker.addPermissionFields(companyId, document);
        }
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        this._setCommitImmediately(searchContext, commitImmediately);
        indexWriter.updateDocuments(searchContext, documents);
    }

    public void updatePermissionFields(String name, String primKey) {
        if (this._indexStatusManager.isIndexReadOnly()) {
            return;
        }
        if (PermissionThreadLocal.isFlushResourcePermissionEnabled((String)name, (String)primKey)) {
            this._searchPermissionChecker.updatePermissionFields(this._getIndexerModelName(name), primKey);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        IndexWriterHelperConfiguration indexWriterHelperConfiguration = (IndexWriterHelperConfiguration)ConfigurableUtil.createConfigurable(IndexWriterHelperConfiguration.class, properties);
        this._commitImmediately = indexWriterHelperConfiguration.indexCommitImmediately();
    }

    private void _enforceStandardUID(Collection<Document> documents) {
        documents.forEach(this::_enforceStandardUID);
    }

    private void _enforceStandardUID(Document document) {
        this.uidFactory.getUID(document);
    }

    private String _getIndexerModelName(String name) {
        String[] names = StringUtil.split((String)name, (String)ResourceActionsUtil.getCompositeModelNameSeparator());
        return names[0];
    }

    private void _setCommitImmediately(SearchContext searchContext, boolean commitImmediately) {
        if (!commitImmediately) {
            searchContext.setCommitImmediately(this._commitImmediately);
        } else {
            searchContext.setCommitImmediately(true);
        }
    }
}

