/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.internal.instance.lifecycle.IndexOnStartupPortalInstanceLifecycleListener;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={})
public class IndexOnStartupExecutor
implements ServiceTrackerCustomizer<Indexer<?>, Indexer<?>> {
    private static final Log _log = LogFactoryUtil.getLog(IndexOnStartupExecutor.class);
    private BundleContext _bundleContext;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    private final Map<String, ServiceRegistration<PortalInstanceLifecycleListener>> _serviceRegistrations = new HashMap<String, ServiceRegistration<PortalInstanceLifecycleListener>>();
    private ServiceTracker<Indexer<?>, Indexer<?>> _serviceTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Indexer<?> addingService(ServiceReference<Indexer<?>> serviceReference) {
        Indexer indexer = (Indexer)this._bundleContext.getService(serviceReference);
        boolean indexerIndexOnStartup = GetterUtil.getBoolean((Object)serviceReference.getProperty("index.on.startup"));
        String className = indexer.getClassName();
        if (!indexerIndexOnStartup || Validator.isNull((String)className) || this._isBaseSearcher(indexer.getClass())) {
            return indexer;
        }
        Map<String, ServiceRegistration<PortalInstanceLifecycleListener>> map = this._serviceRegistrations;
        synchronized (map) {
            if (this._serviceRegistrations.containsKey(className)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Skip duplicate service registration for " + className));
                }
                return indexer;
            }
            IndexOnStartupPortalInstanceLifecycleListener portalInstanceLifecycleListener = new IndexOnStartupPortalInstanceLifecycleListener(this._indexWriterHelper, className);
            ServiceRegistration serviceRegistration = this._bundleContext.registerService(PortalInstanceLifecycleListener.class, (Object)portalInstanceLifecycleListener, null);
            this._serviceRegistrations.put(className, (ServiceRegistration<PortalInstanceLifecycleListener>)serviceRegistration);
        }
        return indexer;
    }

    public void modifiedService(ServiceReference<Indexer<?>> serviceReference, Indexer<?> indexer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<Indexer<?>> serviceReference, Indexer<?> indexer) {
        Map<String, ServiceRegistration<PortalInstanceLifecycleListener>> map = this._serviceRegistrations;
        synchronized (map) {
            ServiceRegistration<PortalInstanceLifecycleListener> serviceRegistration = this._serviceRegistrations.remove(indexer.getClassName());
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        if (PropsValues.INDEX_ON_STARTUP) {
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutorService.schedule(() -> {
                if (this._bundleContext != null) {
                    this._serviceTracker = new ServiceTracker(this._bundleContext, Indexer.class, (ServiceTrackerCustomizer)this);
                    this._serviceTracker.open();
                }
            }, (long)PropsValues.INDEX_ON_STARTUP_DELAY, TimeUnit.SECONDS);
            scheduledExecutorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        this._bundleContext = null;
        HashSet<String> removedIndexerClassNames = new HashSet<String>();
        Map<String, ServiceRegistration<PortalInstanceLifecycleListener>> map = this._serviceRegistrations;
        synchronized (map) {
            for (Map.Entry<String, ServiceRegistration<PortalInstanceLifecycleListener>> entry : this._serviceRegistrations.entrySet()) {
                ServiceRegistration<PortalInstanceLifecycleListener> serviceRegistration = entry.getValue();
                serviceRegistration.unregister();
                removedIndexerClassNames.add(entry.getKey());
            }
            for (String removedIndexerClassName : removedIndexerClassNames) {
                this._serviceRegistrations.remove(removedIndexerClassName);
            }
        }
        if (this._serviceTracker != null) {
            this._serviceTracker.close();
        }
    }

    private boolean _isBaseSearcher(Class<?> indexerClass) {
        while (indexerClass != null && !Object.class.equals(indexerClass)) {
            if (indexerClass.equals(BaseSearcher.class)) {
                return true;
            }
            indexerClass = indexerClass.getSuperclass();
        }
        return false;
    }
}

