/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.IndexAdminHelper;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.CompanyLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={IndexAdminHelper.class})
public class IndexAdminHelperImpl
implements IndexAdminHelper {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private SearchEngineHelper _searchEngineHelper;

    public synchronized String backup(long companyId, String backupName) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        return searchEngine.backup(companyId, backupName);
    }

    public synchronized void backup(String backupName) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        for (Company company : this._companyLocalService.getCompanies()) {
            searchEngine.backup(company.getCompanyId(), backupName);
        }
    }

    public synchronized void removeBackup(long companyId, String backupName) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        searchEngine.removeBackup(companyId, backupName);
    }

    public synchronized void removeBackup(String backupName) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        for (Company company : this._companyLocalService.getCompanies()) {
            searchEngine.removeBackup(company.getCompanyId(), backupName);
        }
    }

    public synchronized void restore(long companyId, String backupName) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        searchEngine.restore(companyId, backupName);
    }

    public synchronized void restore(String backupName) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine();
        for (Company company : this._companyLocalService.getCompanies()) {
            searchEngine.restore(company.getCompanyId(), backupName);
        }
    }
}

