/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.summary;

import com.liferay.portal.kernel.search.highlight.HighlightUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.internal.summary.SummaryImpl;
import com.liferay.portal.search.summary.Summary;
import com.liferay.portal.search.summary.SummaryBuilder;
import com.liferay.portal.util.HtmlImpl;
import java.util.Locale;

public class SummaryBuilderImpl
implements SummaryBuilder {
    private static final String[] _ESCAPE_SAFE_HIGHLIGHTS = new String[]{"[@HIGHLIGHT1@]", "[@HIGHLIGHT2@]"};
    private static final String[] _HIGHLIGHT_TAGS = new String[]{"<liferay-hl>", "</liferay-hl>"};
    private String _content;
    private boolean _escape = true;
    private boolean _highlight;
    private final Html _html = new HtmlImpl();
    private Locale _locale;
    private int _maxContentLength;
    private String _title;

    public Summary build() {
        return new SummaryImpl(this.buildTitle(), this.buildContent(), this._locale);
    }

    public void setContent(String content) {
        this._content = content;
    }

    public void setEscape(boolean escape) {
        this._escape = escape;
    }

    public void setHighlight(boolean highlight) {
        this._highlight = highlight;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public void setMaxContentLength(int maxContentLength) {
        this._maxContentLength = maxContentLength;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    protected String buildContent() {
        if (Validator.isNull((String)this._content)) {
            return "";
        }
        if (this._highlight) {
            return this.buildContentHighlighted();
        }
        return this.buildContentPlain();
    }

    protected String buildContentHighlighted() {
        return this._escapeAndHighlight(this._content);
    }

    protected String buildContentPlain() {
        if (this._maxContentLength <= 0 || this._content.length() <= this._maxContentLength) {
            return this._content;
        }
        return StringUtil.shorten((String)this._content, (int)this._maxContentLength);
    }

    protected String buildTitle() {
        if (Validator.isNull((String)this._title)) {
            return "";
        }
        if (this._highlight) {
            return this.buildTitleHighlighted();
        }
        return this.buildTitlePlain();
    }

    protected String buildTitleHighlighted() {
        return this._escapeAndHighlight(this._title);
    }

    protected String buildTitlePlain() {
        return this._title;
    }

    private String _escapeAndHighlight(String text) {
        text = StringUtil.replace((String)text, (String[])_HIGHLIGHT_TAGS, (String[])_ESCAPE_SAFE_HIGHLIGHTS);
        if (this._escape) {
            text = this._html.escape(text);
        }
        text = StringUtil.replace((String)text, (String[])_ESCAPE_SAFE_HIGHLIGHTS, (String[])HighlightUtil.HIGHLIGHTS);
        return text;
    }
}

