/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.sort;

import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.contributor.sort.SortFieldNameTranslator;
import com.liferay.portal.search.sort.SortFieldBuilder;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={SortFieldBuilder.class})
public class SortFieldBuilderImpl
implements SortFieldBuilder {
    @Reference
    protected IndexerRegistry indexerRegistry;
    @Reference
    protected Props props;
    private Set<String> _defaultSortableTextFields;
    private final Map<String, SortFieldNameTranslator> _sortFieldNameTranslators = new ConcurrentHashMap<String, SortFieldNameTranslator>();

    public String getSortField(String entityClassName, String orderByCol) {
        String sortField = this.doGetSortField(entityClassName, orderByCol);
        if (this._defaultSortableTextFields.contains(sortField)) {
            return Field.getSortableFieldName((String)sortField);
        }
        return sortField;
    }

    public String getSortField(String entityClassName, String orderByCol, int sortType) {
        if (sortType == 7 || sortType == 5 || sortType == 4 || sortType == 6) {
            return Field.getSortableFieldName((String)orderByCol);
        }
        return this.getSortField(entityClassName, orderByCol);
    }

    @Activate
    protected void activate() {
        this._defaultSortableTextFields = SetUtil.fromArray((Object[])this.props.getArray("index.sortable.text.fields"));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addSortFieldNameTranslator(SortFieldNameTranslator sortFieldNameTranslator, Map<String, Object> properties) {
        String entryClassName = GetterUtil.getString((Object)properties.get("entry.class.name"));
        if (Validator.isNull((String)entryClassName)) {
            throw new IllegalArgumentException("No entry.class.name provided");
        }
        this._sortFieldNameTranslators.put(entryClassName, sortFieldNameTranslator);
    }

    protected String doGetSortField(String entityClassName, String orderByCol) {
        SortFieldNameTranslator sortFieldNameTranslator = this._sortFieldNameTranslators.get(entityClassName);
        String sortFieldName = orderByCol;
        if (sortFieldNameTranslator == null) {
            return this.getSortFieldNameFromIndexer(entityClassName, orderByCol);
        }
        sortFieldName = sortFieldNameTranslator.getSortFieldName(orderByCol);
        return sortFieldName;
    }

    @Deprecated
    protected String getSortFieldNameFromIndexer(String entityClassName, String orderByCol) {
        Indexer indexer = this.indexerRegistry.getIndexer(entityClassName);
        return indexer.getSortField(orderByCol);
    }

    protected void removeSortFieldNameTranslator(SortFieldNameTranslator sortFieldNameTranslator, Map<String, Object> properties) {
        String entryClassName = GetterUtil.getString((Object)properties.get("entry.class.name"));
        if (Validator.isNull((String)entryClassName)) {
            return;
        }
        this._sortFieldNameTranslators.remove(entryClassName);
    }
}

