/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.searcher;

import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ExpandoQueryContributor;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.IndexSearcherHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.facet.faceted.searcher.FacetedSearcher;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.search.generic.StringQuery;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.internal.indexer.PreFilterContributorHelper;
import java.util.LinkedHashMap;
import java.util.Map;

public class FacetedSearcherImpl
extends BaseSearcher
implements FacetedSearcher {
    private final ExpandoQueryContributor _expandoQueryContributor;
    private final IndexerRegistry _indexerRegistry;
    private final IndexSearcherHelper _indexSearcherHelper;
    private final PreFilterContributorHelper _preFilterContributorHelper;
    private final SearchEngineHelper _searchEngineHelper;

    public FacetedSearcherImpl(ExpandoQueryContributor expandoQueryContributor, IndexerRegistry indexerRegistry, IndexSearcherHelper indexSearcherHelper, PreFilterContributorHelper preFilterContributorHelper, SearchEngineHelper searchEngineHelper) {
        this._expandoQueryContributor = expandoQueryContributor;
        this._indexerRegistry = indexerRegistry;
        this._indexSearcherHelper = indexSearcherHelper;
        this._preFilterContributorHelper = preFilterContributorHelper;
        this._searchEngineHelper = searchEngineHelper;
    }

    protected BooleanQuery createFullQuery(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        BooleanClause[] booleanClauses;
        BooleanQueryImpl searchQuery = new BooleanQueryImpl();
        boolean luceneSyntax = GetterUtil.getBoolean((Object)searchContext.getAttribute("search.lucene.syntax"));
        Map<String, Indexer<?>> entryClassNameIndexerMap = this._getEntryClassNameIndexerMap(this._getEntryClassNames(searchContext), searchContext.getSearchEngineId());
        this._addSearchKeywords((BooleanQuery)searchQuery, luceneSyntax, entryClassNameIndexerMap, searchContext);
        this._addSearchTerms((BooleanQuery)searchQuery, fullQueryBooleanFilter, luceneSyntax, entryClassNameIndexerMap, searchContext);
        this._addPreFilters(fullQueryBooleanFilter, entryClassNameIndexerMap, searchContext);
        BooleanQueryImpl fullQuery = new BooleanQueryImpl();
        if (fullQueryBooleanFilter.hasClauses()) {
            fullQuery.setPreBooleanFilter(fullQueryBooleanFilter);
        }
        if (searchQuery.hasClauses()) {
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if ((booleanClauses = searchContext.getBooleanClauses()) != null) {
            for (BooleanClause booleanClause : booleanClauses) {
                fullQuery.add((Query)booleanClause.getClause(), booleanClause.getBooleanClauseOccur());
            }
        }
        this._postProcessFullQuery(entryClassNameIndexerMap, (BooleanQuery)fullQuery, searchContext);
        return fullQuery;
    }

    protected Hits doSearch(SearchContext searchContext) throws SearchException {
        String keywords = StringUtil.trim((String)searchContext.getKeywords());
        if (Validator.isBlank((String)keywords) && !GetterUtil.getBoolean((Object)searchContext.getAttribute("search.empty.search"))) {
            return new HitsImpl();
        }
        try {
            searchContext.setSearchEngineId(this.getSearchEngineId());
            BooleanFilter booleanFilter = new BooleanFilter();
            booleanFilter.addRequiredTerm("companyId", searchContext.getCompanyId());
            Query query = this._getFinalQuery((Query)this.createFullQuery(booleanFilter, searchContext));
            QueryConfig queryConfig = searchContext.getQueryConfig();
            query.setQueryConfig(queryConfig);
            return this._indexSearcherHelper.search(searchContext, query);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    protected boolean isUseSearchResultPermissionFilter(SearchContext searchContext) {
        Object[] entryClassNames = this._getEntryClassNames(searchContext);
        if (ArrayUtil.isEmpty((Object[])entryClassNames)) {
            return super.isFilterSearch();
        }
        for (Object entryClassName : entryClassNames) {
            Indexer indexer = this._indexerRegistry.getIndexer((String)entryClassName);
            if (indexer == null || !indexer.isFilterSearch()) continue;
            return true;
        }
        return super.isFilterSearch();
    }

    private void _addIndexerProvidedSearchTerms(BooleanQuery searchQuery, Indexer<?> indexer, BooleanFilter booleanFilter, boolean luceneSyntax, SearchContext searchContext) throws Exception {
        if (!luceneSyntax) {
            indexer.postProcessSearchQuery(searchQuery, booleanFilter, searchContext);
        }
        for (IndexerPostProcessor indexerPostProcessor : indexer.getIndexerPostProcessors()) {
            indexerPostProcessor.postProcessSearchQuery(searchQuery, booleanFilter, searchContext);
        }
    }

    private void _addPreFilters(BooleanFilter booleanFilter, Map<String, Indexer<?>> entryClassNameIndexerMap, SearchContext searchContext) {
        this._preFilterContributorHelper.contribute(booleanFilter, entryClassNameIndexerMap, searchContext);
    }

    private void _addSearchKeywords(BooleanQuery booleanQuery, boolean luceneSyntax, Map<String, Indexer<?>> entryClassNameIndexerMap, SearchContext searchContext) throws Exception {
        String keywords = searchContext.getKeywords();
        if (luceneSyntax) {
            if (!Validator.isBlank((String)keywords)) {
                booleanQuery.add((Query)new StringQuery(keywords), BooleanClauseOccur.MUST);
            }
        } else {
            this._expandoQueryContributor.contribute(keywords, booleanQuery, ArrayUtil.toStringArray(entryClassNameIndexerMap.keySet()), searchContext);
        }
    }

    private void _addSearchTerms(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, boolean luceneSyntax, Map<String, Indexer<?>> entryClassNameIndexerMap, SearchContext searchContext) throws Exception {
        for (Indexer<?> indexer : entryClassNameIndexerMap.values()) {
            this._addIndexerProvidedSearchTerms(searchQuery, indexer, fullQueryBooleanFilter, luceneSyntax, searchContext);
        }
    }

    private Map<String, Indexer<?>> _getEntryClassNameIndexerMap(String[] entryClassNames, String searchEngineId) {
        LinkedHashMap entryClassNameIndexerMap = new LinkedHashMap(entryClassNames.length);
        for (String entryClassName : entryClassNames) {
            Indexer indexer = this._indexerRegistry.getIndexer(entryClassName);
            if (indexer == null || !searchEngineId.equals(indexer.getSearchEngineId())) continue;
            entryClassNameIndexerMap.put(entryClassName, indexer);
        }
        return entryClassNameIndexerMap;
    }

    private String[] _getEntryClassNames(SearchContext searchContext) {
        Object[] entryClassNames = searchContext.getEntryClassNames();
        if (!ArrayUtil.isEmpty((Object[])entryClassNames)) {
            return entryClassNames;
        }
        return this._searchEngineHelper.getEntryClassNames();
    }

    private Query _getFinalQuery(Query query) {
        if (query.hasChildren()) {
            return query;
        }
        MatchAllQuery matchAllQuery = new MatchAllQuery();
        matchAllQuery.setPostFilter(query.getPostFilter());
        matchAllQuery.setPreBooleanFilter(query.getPreBooleanFilter());
        return matchAllQuery;
    }

    private void _postProcessFullQuery(Map<String, Indexer<?>> entryClassNameIndexerMap, BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
        for (Indexer<?> indexer : entryClassNameIndexerMap.values()) {
            for (IndexerPostProcessor indexerPostProcessor : indexer.getIndexerPostProcessors()) {
                indexerPostProcessor.postProcessFullQuery(fullQuery, searchContext);
            }
        }
    }
}

