/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.result;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.SearchResultManager;
import com.liferay.portal.kernel.search.result.SearchResultTranslator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchResultTranslator.class})
public class SearchResultTranslatorImpl
implements SearchResultTranslator {
    private static final Log _log = LogFactoryUtil.getLog(SearchResultTranslatorImpl.class);
    private SearchResultManager _searchResultManager;

    @Reference(unbind="-")
    public void setSearchResultManager(SearchResultManager searchResultManager) {
        this._searchResultManager = searchResultManager;
    }

    public List<SearchResult> translate(Hits hits, Locale locale, PortletRequest portletRequest, PortletResponse portletResponse) {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        for (Document document : hits.getDocs()) {
            try {
                SearchResult searchResult = this._searchResultManager.createSearchResult(document);
                int index = searchResults.indexOf(searchResult);
                if (index < 0) {
                    searchResults.add(searchResult);
                } else {
                    searchResult = (SearchResult)searchResults.get(index);
                }
                String version = document.get("version");
                if (Validator.isNotNull((String)version)) {
                    searchResult.addVersion(version);
                }
                this._searchResultManager.updateSearchResult(searchResult, document, locale, portletRequest, portletResponse);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
                _log.warn((Object)("Search index is stale and contains entry {" + entryClassPK + "}"), (Throwable)e);
            }
        }
        return searchResults;
    }
}

