/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.result;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.SearchResultManager;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.SummaryFactory;
import com.liferay.portal.kernel.search.result.SearchResultContributor;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.HashMap;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={SearchResultManager.class})
public class SearchResultManagerImpl
implements SearchResultManager {
    private ClassNameLocalService _classNameLocalService;
    private final HashMap<String, SearchResultContributor> _searchResultContributors = new HashMap();
    private SummaryFactory _summaryFactory;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void addSearchResultContributor(SearchResultContributor searchResultContributor) {
        this._searchResultContributors.put(searchResultContributor.getEntryClassName(), searchResultContributor);
    }

    public SearchResult createSearchResult(Document document) throws PortalException {
        SearchResultContributor searchResultContributor = this.getSearchResultContributor(document);
        if (searchResultContributor == null) {
            return this.createSearchResultWithEntryClass(document);
        }
        if (this.isClassPresent(document)) {
            return this.createSearchResultWithClass(document);
        }
        return this.createSearchResultWithEntryClass(document);
    }

    public void removeSearchResultContributor(SearchResultContributor searchResultContributor) {
        this._searchResultContributors.remove(searchResultContributor.getEntryClassName());
    }

    @Reference(unbind="-")
    public void setClassNameLocalService(ClassNameLocalService classNameLocalService) {
        this._classNameLocalService = classNameLocalService;
    }

    @Reference(unbind="-")
    public void setSummaryFactory(SummaryFactory newSummaryFactory) {
        this._summaryFactory = newSummaryFactory;
    }

    public void updateSearchResult(SearchResult searchResult, Document document, Locale locale, PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        SearchResultContributor searchResultContributor = this.getSearchResultContributor(document);
        if (searchResultContributor != null && this.isClassPresent(document)) {
            searchResultContributor.addRelatedModel(searchResult, document, locale, portletRequest, portletResponse);
            if (searchResult.getSummary() == null) {
                searchResult.setSummary(this.getSummaryWithClass(searchResult, locale));
            }
            return;
        }
        searchResult.setSummary(this.getSummaryWithEntryClass(document, locale, portletRequest, portletResponse));
    }

    protected SearchResult createSearchResultWithClass(Document document) throws PortalException {
        long classNameId = GetterUtil.getLong((String)document.get("classNameId"));
        ClassName className = this._classNameLocalService.getClassName(classNameId);
        if (className == null) {
            throw new PortalException("Unable to get class name from class name ID " + classNameId);
        }
        long classPK = GetterUtil.getLong((String)document.get("classPK"));
        return new SearchResult(className.getClassName(), classPK);
    }

    protected SearchResult createSearchResultWithEntryClass(Document document) {
        String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
        long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
        return new SearchResult(entryClassName, entryClassPK);
    }

    protected SearchResultContributor getSearchResultContributor(Document document) {
        String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
        return this._searchResultContributors.get(entryClassName);
    }

    protected Summary getSummaryWithClass(SearchResult searchResult, Locale locale) throws PortalException {
        return this._summaryFactory.getSummary(searchResult.getClassName(), searchResult.getClassPK(), locale);
    }

    protected Summary getSummaryWithEntryClass(Document document, Locale locale, PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
        long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
        return this._summaryFactory.getSummary(document, entryClassName, entryClassPK, locale, portletRequest, portletResponse);
    }

    protected boolean isClassPresent(Document document) {
        long classNameId = GetterUtil.getLong((String)document.get("classNameId"));
        long classPK = GetterUtil.getLong((String)document.get("classPK"));
        return classNameId > 0L && classPK > 0L;
    }
}

