/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.query.QueryHelper;
import java.io.Serializable;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={QueryHelper.class})
public class QueryHelperImpl
implements QueryHelper {
    protected Localization localization;

    public void addSearchLocalizedTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) {
        this.addSearchTerm(searchQuery, searchContext, this.getLocalizedName(field, searchContext.getLocale()), like);
    }

    public Query addSearchTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) {
        if (Validator.isBlank((String)field)) {
            return null;
        }
        String value = "";
        Serializable serializable = searchContext.getAttribute(field);
        if (serializable != null) {
            Class<?> clazz = serializable.getClass();
            value = clazz.isArray() ? StringUtil.merge((Object[])((Object[])serializable)) : GetterUtil.getString((Object)serializable);
        }
        if (!Validator.isBlank((String)value) && searchContext.getFacet(field) != null) {
            return null;
        }
        if (Validator.isBlank((String)value)) {
            value = searchContext.getKeywords();
        }
        if (Validator.isBlank((String)value)) {
            return null;
        }
        Query query = null;
        if (searchContext.isAndSearch()) {
            query = searchQuery.addRequiredTerm(field, value, like);
        } else {
            try {
                query = searchQuery.addTerm(field, value, like);
            }
            catch (ParseException pe) {
                throw new SystemException((Throwable)pe);
            }
        }
        return query;
    }

    protected Localization getLocalization() {
        if (this.localization != null) {
            return this.localization;
        }
        return LocalizationUtil.getLocalization();
    }

    protected String getLocalizedName(String name, Locale locale) {
        Localization localization = this.getLocalization();
        return localization.getLocalizedName(name, LocaleUtil.toLanguageId((Locale)locale));
    }
}

