/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query;

import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.query.FieldQueryFactory;
import com.liferay.portal.search.analysis.FieldQueryBuilder;
import com.liferay.portal.search.analysis.FieldQueryBuilderFactory;
import com.liferay.portal.search.internal.analysis.TitleFieldQueryBuilder;
import java.util.HashSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={FieldQueryFactory.class})
public class FieldQueryFactoryImpl
implements FieldQueryFactory {
    @Reference
    protected TitleFieldQueryBuilder titleQueryBuilder;
    private final HashSet<FieldQueryBuilderFactory> _fieldQueryBuilderFactories = new HashSet();

    public Query createQuery(String fieldName, String keywords, boolean like, boolean splitKeywords) {
        FieldQueryBuilder fieldQueryBuilder = this.getQueryBuilder(fieldName);
        return fieldQueryBuilder.build(fieldName, keywords);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addFieldQueryBuilderFactory(FieldQueryBuilderFactory fieldQueryBuilderFactory) {
        this._fieldQueryBuilderFactories.add(fieldQueryBuilderFactory);
    }

    protected FieldQueryBuilder getDefaultQueryBuilder() {
        return this.titleQueryBuilder;
    }

    protected FieldQueryBuilder getQueryBuilder(String fieldName) {
        for (FieldQueryBuilderFactory fieldQueryBuilderFactory : this._fieldQueryBuilderFactories) {
            FieldQueryBuilder fieldQueryBuilder = fieldQueryBuilderFactory.getQueryBuilder(fieldName);
            if (fieldQueryBuilder == null) continue;
            return fieldQueryBuilder;
        }
        return this.getDefaultQueryBuilder();
    }

    protected void removeFieldQueryBuilderFactory(FieldQueryBuilderFactory fieldQueryBuilderFactory) {
        this._fieldQueryBuilderFactories.remove(fieldQueryBuilderFactory);
    }
}

