/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.permission;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchResourceException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.permission.SearchPermissionDocumentContributor;
import com.liferay.portal.search.spi.model.permission.SearchPermissionFieldContributor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={SearchPermissionDocumentContributor.class})
public class SearchPermissionDocumentContributorImpl
implements SearchPermissionDocumentContributor {
    private static final Log _log = LogFactoryUtil.getLog(SearchPermissionDocumentContributorImpl.class);
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    private final Collection<SearchPermissionFieldContributor> _searchPermissionFieldContributors = new CopyOnWriteArrayList<SearchPermissionFieldContributor>();

    public void addPermissionFields(long companyId, Document document) {
        long classNameId;
        boolean relatedEntry;
        long groupId = GetterUtil.getLong((String)document.get("groupId"));
        String className = document.get("entryClassName");
        String classPK = document.get("entryClassPK");
        if (Validator.isNull((String)className) && Validator.isNull((String)classPK)) {
            className = document.get("rootEntryClassName");
            classPK = document.get("rootEntryClassPK");
        }
        if ((relatedEntry = GetterUtil.getBoolean((String)document.get("relatedEntry"))) && (classNameId = GetterUtil.getLong((String)document.get("classNameId"))) > 0L) {
            className = this._portal.getClassName(classNameId);
            classPK = document.get("classPK");
        }
        this.addPermissionFields(companyId, groupId, className, GetterUtil.getLong((String)classPK), document);
    }

    public void addPermissionFields(long companyId, long groupId, String className, long classPK, Document document) {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(className);
        if (!indexer.isPermissionAware()) {
            return;
        }
        String viewActionId = document.get("viewActionId");
        if (Validator.isNull((String)viewActionId)) {
            viewActionId = "VIEW";
        }
        this._addPermissionFields(companyId, groupId, className, classPK, viewActionId, document);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addSearchPermissionFieldContributor(SearchPermissionFieldContributor searchPermissionFieldContributor) {
        this._searchPermissionFieldContributors.add(searchPermissionFieldContributor);
    }

    protected void removeSearchPermissionFieldContributor(SearchPermissionFieldContributor searchPermissionFieldContributor) {
        this._searchPermissionFieldContributors.remove(searchPermissionFieldContributor);
    }

    private void _addPermissionFields(long companyId, long groupId, String className, long classPK, String viewActionId, Document document) {
        block8: {
            for (SearchPermissionFieldContributor searchPermissionFieldContributor : this._searchPermissionFieldContributors) {
                searchPermissionFieldContributor.contribute(document, className, classPK);
            }
            try {
                List roles = this._resourcePermissionLocalService.getRoles(companyId, className, 4, String.valueOf(classPK), viewActionId);
                if (roles.isEmpty()) {
                    return;
                }
                ArrayList<Long> roleIds = new ArrayList<Long>();
                ArrayList<String> groupRoleIds = new ArrayList<String>();
                for (Role role : roles) {
                    if (role.getType() == 3 || role.getType() == 2) {
                        groupRoleIds.add(groupId + "-" + role.getRoleId());
                        continue;
                    }
                    roleIds.add(role.getRoleId());
                }
                document.addKeyword("roleId", roleIds.toArray(new Long[roleIds.size()]));
                document.addKeyword("groupRoleId", groupRoleIds.toArray(new String[groupRoleIds.size()]));
            }
            catch (NoSuchResourceException nsre) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nsre, (Throwable)nsre);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to get permission fields for class name ", className, " and class PK ", classPK}), (Throwable)e);
            }
        }
    }
}

