/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.permission;

import aQute.bnd.annotation.ProviderType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistry;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchResultPermissionFilter;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.FacetPostProcessor;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.search.configuration.DefaultSearchResultPermissionFilterConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

@ProviderType
public class DefaultSearchResultPermissionFilter
implements SearchResultPermissionFilter {
    private static final String[] _PERMISSION_SELECTED_FIELD_NAMES = new String[]{"companyId", "entryClassName", "entryClassPK"};
    private static final Log _log = LogFactoryUtil.getLog(DefaultSearchResultPermissionFilter.class);
    private final FacetPostProcessor _facetPostProcessor;
    private final IndexerRegistry _indexerRegistry;
    private double _indexPermissionFilterSearchAmplificationFactor;
    private final PermissionChecker _permissionChecker;
    private final int _permissionFilteredSearchResultAccurateCountThreshold;
    private Props _props;
    private final RelatedEntryIndexerRegistry _relatedEntryIndexerRegistry;
    private final Function<SearchContext, Hits> _searchFunction;
    private final int _searchQueryResultWindowLimit;

    public DefaultSearchResultPermissionFilter(FacetPostProcessor facetPostProcessor, IndexerRegistry indexerRegistry, PermissionChecker permissionChecker, Props props, RelatedEntryIndexerRegistry relatedEntryIndexerRegistry, Function<SearchContext, Hits> searchFunction, DefaultSearchResultPermissionFilterConfiguration defaultSearchResultPermissionFilterConfiguration) {
        this._facetPostProcessor = facetPostProcessor;
        this._indexerRegistry = indexerRegistry;
        this._permissionChecker = permissionChecker;
        this._relatedEntryIndexerRegistry = relatedEntryIndexerRegistry;
        this._searchFunction = searchFunction;
        this._permissionFilteredSearchResultAccurateCountThreshold = defaultSearchResultPermissionFilterConfiguration.permissionFilteredSearchResultAccurateCountThreshold();
        this._searchQueryResultWindowLimit = defaultSearchResultPermissionFilterConfiguration.searchQueryResultWindowLimit();
        this.setProps(props);
    }

    public Hits search(SearchContext searchContext) {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isAllFieldsSelected()) {
            queryConfig.setSelectedFieldNames(this.getSelectedFieldNames(queryConfig.getSelectedFieldNames()));
        }
        int end = searchContext.getEnd();
        int start = searchContext.getStart();
        if (end == -1 && start == -1) {
            Hits hits = this.getHits(searchContext);
            if (!this.isGroupAdmin(searchContext)) {
                this.filterHits(hits, searchContext);
            }
            return hits;
        }
        if (start < 0 || start > end) {
            return new HitsImpl();
        }
        if (this.isGroupAdmin(searchContext)) {
            return this.getHits(searchContext);
        }
        SlidingWindowSearcher slidingWindowSearcher = new SlidingWindowSearcher();
        return slidingWindowSearcher.search(start, end, searchContext);
    }

    protected void filterHits(Hits hits, SearchContext searchContext) {
        ArrayList<Document> docs = new ArrayList<Document>();
        ArrayList<Document> excludeDocs = new ArrayList<Document>();
        ArrayList<Float> scores = new ArrayList<Float>();
        boolean companyAdmin = this._permissionChecker.isCompanyAdmin(this._permissionChecker.getCompanyId());
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        Document[] documents = hits.getDocs();
        for (int i = 0; i < documents.length; ++i) {
            if (this._isIncludeDocument(documents[i], this._permissionChecker.getCompanyId(), companyAdmin, status)) {
                docs.add(documents[i]);
                scores.add(Float.valueOf(hits.score(i)));
                continue;
            }
            excludeDocs.add(documents[i]);
        }
        if (!excludeDocs.isEmpty()) {
            Map facets = searchContext.getFacets();
            for (Facet facet : facets.values()) {
                this._facetPostProcessor.exclude(excludeDocs, facet);
            }
        }
        hits.setDocs(docs.toArray(new Document[docs.size()]));
        hits.setScores(ArrayUtil.toFloatArray(scores));
        hits.setSearchTime((float)(System.currentTimeMillis() - hits.getStart()) / 1000.0f);
        hits.setLength(hits.getLength() - excludeDocs.size());
    }

    protected Hits getHits(SearchContext searchContext) {
        if (searchContext != null && searchContext.getEnd() != -1) {
            int searchResultWindow;
            int end = searchContext.getEnd();
            int start = searchContext.getStart();
            if (start == -1) {
                start = 0;
            }
            if ((searchResultWindow = end - start) > this._searchQueryResultWindowLimit) {
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Search result window size of ", searchResultWindow, " exceeds the configured limit of ", this._searchQueryResultWindowLimit}));
            }
        }
        return this._searchFunction.apply(searchContext);
    }

    protected String[] getSelectedFieldNames(String[] selectedFieldNames) {
        Set set = SetUtil.fromArray((Object[])selectedFieldNames);
        Collections.addAll(set, _PERMISSION_SELECTED_FIELD_NAMES);
        return set.toArray(new String[set.size()]);
    }

    protected boolean isGroupAdmin(SearchContext searchContext) {
        long groupId = GetterUtil.getLong((Object)searchContext.getAttribute("groupId"));
        if (groupId == 0L) {
            return false;
        }
        return this._permissionChecker.isGroupAdmin(groupId);
    }

    protected void setProps(Props props) {
        this._props = props;
        this._indexPermissionFilterSearchAmplificationFactor = GetterUtil.getDouble((String)this._props.get("index.permission.filter.search.amplification.factor"));
    }

    private boolean _isIncludeDocument(Document document, long companyId, boolean companyAdmin, int status) {
        block9: {
            long entryCompanyId = GetterUtil.getLong((String)document.get("companyId"));
            if (entryCompanyId != companyId) {
                return false;
            }
            if (companyAdmin) {
                return true;
            }
            String entryClassName = document.get("entryClassName");
            Indexer indexer = this._indexerRegistry.getIndexer(entryClassName);
            if (indexer == null) {
                return true;
            }
            if (!indexer.isFilterSearch()) {
                return true;
            }
            long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                if (indexer.hasPermission(this._permissionChecker, entryClassName, entryClassPK, "VIEW")) {
                    List relatedEntryIndexers = this._relatedEntryIndexerRegistry.getRelatedEntryIndexers(entryClassName);
                    if (ListUtil.isNotEmpty((List)relatedEntryIndexers)) {
                        for (RelatedEntryIndexer relatedEntryIndexer : relatedEntryIndexers) {
                            if (relatedEntryIndexer.isVisibleRelatedEntry(entryClassPK, status)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block9;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return false;
    }

    private class SlidingWindowSearcher {
        protected List<Document> documents = new ArrayList<Document>();
        protected List<Float> scores = new ArrayList<Float>();
        protected List<Document> standbyDocuments = new ArrayList<Document>();
        protected List<Float> standbyScores = new ArrayList<Float>();

        private SlidingWindowSearcher() {
        }

        public Hits search(int start, int end, SearchContext searchContext) {
            int amplifiedCount = DefaultSearchResultPermissionFilter.this._permissionFilteredSearchResultAccurateCountThreshold;
            double amplificationFactor = 1.0;
            int excludedDocsSize = 0;
            int filteredDocsCount = 0;
            int hitsSize = 0;
            int offset = 0;
            long startTime = 0L;
            while (true) {
                int count = end - filteredDocsCount;
                if (offset > 0 || amplifiedCount < count) {
                    amplifiedCount = (int)Math.ceil((double)count * amplificationFactor);
                }
                if (amplifiedCount > DefaultSearchResultPermissionFilter.this._searchQueryResultWindowLimit && DefaultSearchResultPermissionFilter.this._searchQueryResultWindowLimit > 0) {
                    amplifiedCount = DefaultSearchResultPermissionFilter.this._searchQueryResultWindowLimit;
                }
                int amplifiedEnd = offset + amplifiedCount;
                searchContext.setEnd(amplifiedEnd);
                searchContext.setStart(offset);
                Hits hits = DefaultSearchResultPermissionFilter.this.getHits(searchContext);
                if (startTime == 0L) {
                    hitsSize = hits.getLength();
                    startTime = hits.getStart();
                }
                Document[] oldDocs = hits.getDocs();
                DefaultSearchResultPermissionFilter.this.filterHits(hits, searchContext);
                Document[] newDocs = hits.getDocs();
                excludedDocsSize += oldDocs.length - newDocs.length;
                this.collectHits(hits, filteredDocsCount += newDocs.length, start, end);
                if (newDocs.length >= count || oldDocs.length < amplifiedCount || amplifiedEnd >= hitsSize) {
                    this.updateDocuments(filteredDocsCount, start, end);
                    this.updateHits(hits, hitsSize - excludedDocsSize, startTime);
                    return hits;
                }
                offset = amplifiedEnd;
                amplificationFactor = this._getAmplificationFactor(filteredDocsCount, offset);
            }
        }

        protected void collectHits(Hits hits, int accumulatedCount, int start, int end) {
            int delta = end - start;
            Document[] docs = hits.getDocs();
            int remaining = docs.length;
            if (accumulatedCount > start && this.documents.size() < delta) {
                int docsEnd;
                int previousAccumulatedCount = accumulatedCount - docs.length;
                int docsStart = 0;
                if (start > previousAccumulatedCount) {
                    docsStart = start - previousAccumulatedCount;
                }
                if ((docsEnd = docsStart + (delta - this.documents.size())) > docs.length) {
                    docsEnd = docs.length;
                }
                for (int i = docsStart; i < docsEnd; ++i) {
                    this.documents.add(docs[i]);
                    this.scores.add(Float.valueOf(hits.score(i)));
                }
                if ((remaining -= docsEnd) == 0) {
                    return;
                }
            }
            for (int i = docs.length - remaining; i < docs.length; ++i) {
                if (this.standbyDocuments.size() == delta) {
                    this.standbyDocuments.remove(0);
                    this.standbyScores.remove(0);
                }
                this.standbyDocuments.add(docs[i]);
                this.standbyScores.add(Float.valueOf(hits.score(i)));
            }
        }

        protected void updateDocuments(int accumulatedCount, int start, int end) {
            if (start < accumulatedCount || this.standbyDocuments.isEmpty()) {
                return;
            }
            this.documents.addAll(0, this.standbyDocuments);
            this.scores.addAll(0, this.standbyScores);
            int delta = end - start;
            int docsStart = start - accumulatedCount;
            int docsEnd = docsStart + delta;
            int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd((int)docsStart, (int)docsEnd, (int)this.documents.size());
            docsStart = startAndEnd[0];
            docsEnd = startAndEnd[1];
            for (int i = 0; i < this.documents.size(); ++i) {
                if (i >= docsStart && i < docsEnd) continue;
                this.documents.remove(i);
                this.scores.remove(i);
            }
        }

        protected void updateHits(Hits hits, int size, long startTime) {
            hits.setDocs(this.documents.toArray(new Document[this.documents.size()]));
            hits.setScores(ArrayUtil.toFloatArray(this.scores));
            hits.setLength(size);
            hits.setSearchTime((float)(System.currentTimeMillis() - startTime) / 1000.0f);
        }

        private double _getAmplificationFactor(double totalViewable, double total) {
            if (totalViewable == 0.0) {
                return DefaultSearchResultPermissionFilter.this._indexPermissionFilterSearchAmplificationFactor;
            }
            return Math.min(1.0 / (totalViewable / total), DefaultSearchResultPermissionFilter.this._indexPermissionFilterSearchAmplificationFactor);
        }
    }
}

