/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.instance.lifecycle;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class SearchIndexPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(SearchIndexPortalInstanceLifecycleListener.class);
    @Reference
    private SearchEngineHelper _searchEngineHelper;

    public void portalInstanceRegistered(Company company) throws Exception {
        try {
            this._searchEngineHelper.initialize(company.getCompanyId());
        }
        catch (Exception e) {
            _log.error((Object)("Unable to initialize search engine for company " + company), (Throwable)e);
        }
    }

    public void portalInstanceUnregistered(Company company) throws Exception {
        try {
            this._searchEngineHelper.removeCompany(company.getCompanyId());
        }
        catch (Exception e) {
            _log.error((Object)("Unable to remove search engine for company " + company), (Throwable)e);
        }
    }
}

