/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistry;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.indexer.IndexerQueryBuilder;
import com.liferay.portal.search.internal.indexer.IndexerPostProcessorsHolder;
import com.liferay.portal.search.internal.indexer.KeywordQueryContributorsHolder;
import com.liferay.portal.search.internal.indexer.ModelKeywordQueryContributorsHolder;
import com.liferay.portal.search.internal.indexer.PreFilterContributorHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.SearchContextContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import com.liferay.portal.search.spi.model.query.contributor.helper.SearchContextContributorHelper;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;

public class IndexerQueryBuilderImpl<T extends BaseModel<?>>
implements IndexerQueryBuilder {
    private final IndexerPostProcessorsHolder _indexerPostProcessorsHolder;
    private final IndexerRegistry _indexerRegistry;
    private final KeywordQueryContributorsHolder _keywordQueryContributorsHolder;
    private final ModelKeywordQueryContributorsHolder _modelKeywordQueryContributorsHolder;
    private final Iterable<SearchContextContributor> _modelSearchContextContributors;
    private final ModelSearchSettings _modelSearchSettings;
    private final PreFilterContributorHelper _preFilterContributorHelper;
    private final RelatedEntryIndexerRegistry _relatedEntryIndexerRegistry;
    private final Iterable<SearchContextContributor> _searchContextContributors;

    public IndexerQueryBuilderImpl(IndexerRegistry indexerRegistry, ModelSearchSettings modelSearchSettings, ModelKeywordQueryContributorsHolder modelKeywordQueryContributorsHolder, Iterable<SearchContextContributor> modelSearchContextContributor, KeywordQueryContributorsHolder keywordQueryContributorsHolder, PreFilterContributorHelper preFilterContributorHelper, Iterable<SearchContextContributor> searchContextContributors, IndexerPostProcessorsHolder indexerPostProcessorsHolder, RelatedEntryIndexerRegistry relatedEntryIndexerRegistry) {
        this._indexerRegistry = indexerRegistry;
        this._modelSearchSettings = modelSearchSettings;
        this._modelKeywordQueryContributorsHolder = modelKeywordQueryContributorsHolder;
        this._modelSearchContextContributors = modelSearchContextContributor;
        this._keywordQueryContributorsHolder = keywordQueryContributorsHolder;
        this._preFilterContributorHelper = preFilterContributorHelper;
        this._searchContextContributors = searchContextContributors;
        this._indexerPostProcessorsHolder = indexerPostProcessorsHolder;
        this._relatedEntryIndexerRegistry = relatedEntryIndexerRegistry;
    }

    public BooleanQuery getQuery(SearchContext searchContext) {
        searchContext.setSearchEngineId(this._modelSearchSettings.getSearchEngineId());
        this._resetFullQuery(searchContext);
        Object[] fullQueryEntryClassNames = searchContext.getFullQueryEntryClassNames();
        if (ArrayUtil.isNotEmpty((Object[])fullQueryEntryClassNames)) {
            searchContext.setAttribute("relatedEntryClassNames", (Serializable)this._modelSearchSettings.getSearchClassNames());
        }
        String[] entryClassNames = (String[])ArrayUtil.append((Object[])this._modelSearchSettings.getSearchClassNames(), (Object[])fullQueryEntryClassNames);
        searchContext.setEntryClassNames(entryClassNames);
        this.contributeSearchContext(searchContext);
        Map<String, Indexer<?>> entryClassNameIndexerMap = this._getEntryClassNameIndexerMap(entryClassNames, searchContext.getSearchEngineId());
        BooleanFilter booleanFilter = new BooleanFilter();
        this._addPreFilters(booleanFilter, entryClassNameIndexerMap, searchContext);
        BooleanQuery fullQuery = this.createFullQuery(booleanFilter, searchContext);
        fullQuery.setQueryConfig(searchContext.getQueryConfig());
        return fullQuery;
    }

    protected void addPreFiltersFromModel(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this._preFilterContributorHelper.contribute(booleanFilter, modelSearchSettings, searchContext);
    }

    protected void addSearchTermsFromModel(BooleanQuery booleanQuery, SearchContext searchContext) {
        this.contribute(this._modelKeywordQueryContributorsHolder.getAll(), booleanQuery, searchContext);
    }

    protected void contribute(Stream<KeywordQueryContributor> stream, BooleanQuery booleanQuery, final SearchContext searchContext) {
        stream.forEach(keywordQueryContributor -> keywordQueryContributor.contribute(searchContext.getKeywords(), booleanQuery, new KeywordQueryContributorHelper(){

            public String getClassName() {
                return IndexerQueryBuilderImpl.this._modelSearchSettings.getClassName();
            }

            public Stream<String> getSearchClassNamesStream() {
                return Stream.of(IndexerQueryBuilderImpl.this._modelSearchSettings.getSearchClassNames());
            }

            public SearchContext getSearchContext() {
                return searchContext;
            }
        }));
    }

    protected void contributeSearchContext(SearchContext searchContext) {
        SearchContextContributorHelper searchContextContributorHelper = new SearchContextContributorHelper(){

            public String[] getSearchClassNames() {
                return IndexerQueryBuilderImpl.this._modelSearchSettings.getSearchClassNames();
            }
        };
        this._searchContextContributors.forEach(searchContextContributor -> searchContextContributor.contribute(searchContext, searchContextContributorHelper));
        this._modelSearchContextContributors.forEach(modelSearchContextContributor -> modelSearchContextContributor.contribute(searchContext, searchContextContributorHelper));
    }

    protected BooleanQuery createFullQuery(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) {
        BooleanClause[] booleanClauses;
        BooleanQuery keywordBooleanQuery;
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        if (fullQueryBooleanFilter.hasClauses()) {
            booleanQuery.setPreBooleanFilter(fullQueryBooleanFilter);
        }
        if ((keywordBooleanQuery = this.createKeywordQuery(fullQueryBooleanFilter, searchContext)).hasClauses()) {
            this._add((BooleanQuery)booleanQuery, (Query)keywordBooleanQuery, BooleanClauseOccur.MUST);
        }
        if ((booleanClauses = searchContext.getBooleanClauses()) != null) {
            for (BooleanClause booleanClause : booleanClauses) {
                this._add((BooleanQuery)booleanQuery, (Query)booleanClause.getClause(), booleanClause.getBooleanClauseOccur());
            }
        }
        this.postProcessFullQuery((BooleanQuery)booleanQuery, searchContext);
        return booleanQuery;
    }

    protected BooleanQuery createKeywordQuery(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) {
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        this._addSearchKeywords((BooleanQuery)booleanQuery, searchContext);
        this.addSearchTermsFromModel((BooleanQuery)booleanQuery, searchContext);
        this._addSearchTermsFromIndexerPostProcessors((BooleanQuery)booleanQuery, fullQueryBooleanFilter, searchContext);
        return booleanQuery;
    }

    protected void postProcessFullQuery(BooleanQuery booleanQuery, SearchContext searchContext) {
        Stream<IndexerPostProcessor> stream = this._indexerPostProcessorsHolder.stream();
        stream.forEach(indexerPostProcessor -> {
            try {
                indexerPostProcessor.postProcessFullQuery(booleanQuery, searchContext);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        });
    }

    private void _add(BooleanQuery booleanQuery, Query query, BooleanClauseOccur booleanClauseOccur) {
        try {
            booleanQuery.add(query, booleanClauseOccur);
        }
        catch (ParseException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    private void _addPreFilters(BooleanFilter queryBooleanFilter, Map<String, Indexer<?>> entryClassNameIndexerMap, SearchContext searchContext) {
        this._preFilterContributorHelper.contribute(queryBooleanFilter, entryClassNameIndexerMap, searchContext);
    }

    private void _addSearchKeywords(BooleanQuery booleanQuery, SearchContext searchContext) {
        this.contribute(this._keywordQueryContributorsHolder.getAll(), booleanQuery, searchContext);
    }

    private void _addSearchTermsFromIndexerPostProcessors(BooleanQuery booleanQuery, BooleanFilter booleanFilter, SearchContext searchContext) {
        Stream<IndexerPostProcessor> stream = this._indexerPostProcessorsHolder.stream();
        stream.forEach(indexerPostProcessor -> {
            try {
                indexerPostProcessor.postProcessSearchQuery(booleanQuery, booleanFilter, searchContext);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        });
    }

    private Map<String, Indexer<?>> _getEntryClassNameIndexerMap(String[] entryClassNames, String searchEngineId) {
        LinkedHashMap entryClassNameIndexerMap = new LinkedHashMap(entryClassNames.length);
        for (String entryClassName : entryClassNames) {
            Indexer indexer = this._indexerRegistry.getIndexer(entryClassName);
            if (indexer == null || !searchEngineId.equals(indexer.getSearchEngineId())) continue;
            entryClassNameIndexerMap.put(entryClassName, indexer);
        }
        return entryClassNameIndexerMap;
    }

    private void _resetFullQuery(SearchContext searchContext) {
        searchContext.clearFullQueryEntryClassNames();
        for (RelatedEntryIndexer relatedEntryIndexer : this._relatedEntryIndexerRegistry.getRelatedEntryIndexers()) {
            relatedEntryIndexer.updateFullQuery(searchContext);
        }
    }
}

