/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.search.indexer.IndexerPermissionPostFilter;
import com.liferay.portal.search.spi.model.result.contributor.ModelVisibilityContributor;
import java.util.Optional;
import java.util.function.Supplier;

public class IndexerPermissionPostFilterImpl
implements IndexerPermissionPostFilter {
    private static final Log _log = LogFactoryUtil.getLog(IndexerPermissionPostFilterImpl.class);
    private final Supplier<Optional<ModelResourcePermission>> _modelResourcePermissionSupplier;
    private final Supplier<Optional<ModelVisibilityContributor>> _modelVisibilityContributorSupplier;

    public IndexerPermissionPostFilterImpl(Supplier<Optional<ModelResourcePermission>> modelResourcePermissionSupplier, Supplier<Optional<ModelVisibilityContributor>> modelVisibilityContributorSupplier) {
        this._modelResourcePermissionSupplier = modelResourcePermissionSupplier;
        this._modelVisibilityContributorSupplier = modelVisibilityContributorSupplier;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long entryClassPK) {
        Optional<ModelResourcePermission> optional = this._modelResourcePermissionSupplier.get();
        return optional.map(modelResourcePermission -> this._containsView((ModelResourcePermission<?>)modelResourcePermission, permissionChecker, entryClassPK)).orElse(true);
    }

    public boolean isPermissionAware() {
        Optional<ModelResourcePermission> optional = this._modelResourcePermissionSupplier.get();
        return optional.isPresent();
    }

    public boolean isVisible(long classPK, int status) {
        Optional<ModelVisibilityContributor> optional = this._modelVisibilityContributorSupplier.get();
        return optional.map(modelVisibilityContributor -> modelVisibilityContributor.isVisible(classPK, status)).orElse(true);
    }

    private Boolean _containsView(ModelResourcePermission<?> modelResourcePermission, PermissionChecker permissionChecker, long entryClassPK) {
        try {
            return modelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }
}

