/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.search.indexer.BaseModelDocumentFactory;
import com.liferay.portal.search.indexer.IndexerDocumentBuilder;
import com.liferay.portal.search.internal.indexer.IndexerPostProcessorsHolder;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.stream.Stream;

public class IndexerDocumentBuilderImpl
implements IndexerDocumentBuilder {
    private static final Log _log = LogFactoryUtil.getLog(IndexerDocumentBuilderImpl.class);
    private final BaseModelDocumentFactory _baseModelDocumentFactory;
    private final Iterable<DocumentContributor> _documentContributors;
    private final IndexerPostProcessorsHolder _indexerPostProcessorsHolder;
    private final Iterable<ModelDocumentContributor> _modelDocumentContributors;

    public IndexerDocumentBuilderImpl(BaseModelDocumentFactory baseModelDocumentFactory, Iterable<ModelDocumentContributor> modelDocumentContributors, Iterable<DocumentContributor> documentContributors, IndexerPostProcessorsHolder indexerPostProcessorsHolder) {
        this._baseModelDocumentFactory = baseModelDocumentFactory;
        this._modelDocumentContributors = modelDocumentContributors;
        this._documentContributors = documentContributors;
        this._indexerPostProcessorsHolder = indexerPostProcessorsHolder;
    }

    public <T extends BaseModel<?>> Document getDocument(T baseModel) {
        Document document = this._baseModelDocumentFactory.createDocument(baseModel);
        this._documentContributors.forEach(documentContributor -> documentContributor.contribute(document, baseModel));
        this._modelDocumentContributors.forEach(modelDocumentContributor -> modelDocumentContributor.contribute(document, baseModel));
        this.postProcessDocument(document, baseModel);
        return document;
    }

    public <T extends BaseModel<?>> String getDocumentUID(T baseModel) {
        Document document = this._baseModelDocumentFactory.createDocument(baseModel);
        return document.get("uid");
    }

    protected <T extends BaseModel<?>> void postProcessDocument(Document document, T baseModel) {
        Stream<IndexerPostProcessor> stream = this._indexerPostProcessorsHolder.stream();
        stream.forEach(indexerPostProcessor -> {
            block2: {
                try {
                    indexerPostProcessor.postProcessDocument(document, (Object)baseModel);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to post process document " + document), (Throwable)e);
                }
            }
        });
    }
}

