/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.search.indexer.IndexerDocumentBuilder;
import com.liferay.portal.search.indexer.IndexerPermissionPostFilter;
import com.liferay.portal.search.indexer.IndexerSearcher;
import com.liferay.portal.search.indexer.IndexerSummaryBuilder;
import com.liferay.portal.search.indexer.IndexerWriter;
import com.liferay.portal.search.internal.indexer.IndexerPostProcessorsHolder;
import com.liferay.portal.search.internal.indexer.IndexerQueryBuilderImpl;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public class DefaultIndexer<T extends BaseModel<?>>
implements Indexer<T> {
    private final IndexerDocumentBuilder _indexerDocumentBuilder;
    private final IndexerPermissionPostFilter _indexerPermissionPostFilter;
    private final IndexerPostProcessorsHolder _indexerPostProcessorsHolder;
    private final IndexerQueryBuilderImpl _indexerQueryBuilderImpl;
    private final IndexerSearcher _indexerSearcher;
    private final IndexerSummaryBuilder _indexerSummaryBuilder;
    private final IndexerWriter<T> _indexerWriter;
    private final ModelSearchSettings _modelSearchSettings;

    public DefaultIndexer(ModelSearchSettings modelSearchSettings, IndexerDocumentBuilder indexerDocumentBuilder, IndexerSearcher indexerSearcher, IndexerWriter<T> indexerWriter, IndexerPermissionPostFilter indexerPermissionPostFilter, IndexerQueryBuilderImpl indexerQueryBuilderImpl, IndexerSummaryBuilder indexerSummaryBuilder, IndexerPostProcessorsHolder indexerPostProcessorsHolder) {
        this._modelSearchSettings = modelSearchSettings;
        this._indexerDocumentBuilder = indexerDocumentBuilder;
        this._indexerSearcher = indexerSearcher;
        this._indexerWriter = indexerWriter;
        this._indexerPermissionPostFilter = indexerPermissionPostFilter;
        this._indexerQueryBuilderImpl = indexerQueryBuilderImpl;
        this._indexerSummaryBuilder = indexerSummaryBuilder;
        this._indexerPostProcessorsHolder = indexerPostProcessorsHolder;
    }

    public void delete(long companyId, String uid) throws SearchException {
        this._indexerWriter.delete(companyId, uid);
    }

    public void delete(T baseModel) throws SearchException {
        this._indexerWriter.delete(baseModel);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Indexer)) {
            return false;
        }
        Indexer indexer = (Indexer)object;
        return Objects.equals(this.getClassName(), indexer.getClassName());
    }

    public String getClassName() {
        return this._modelSearchSettings.getClassName();
    }

    public String[] getClassNames() {
        return this.getSearchClassNames();
    }

    public Document getDocument(T baseModel) throws SearchException {
        return this._indexerDocumentBuilder.getDocument(baseModel);
    }

    public BooleanFilter getFacetBooleanFilter(String className, SearchContext searchContext) throws Exception {
        return null;
    }

    public BooleanQuery getFullQuery(SearchContext searchContext) throws SearchException {
        return this._indexerQueryBuilderImpl.getQuery(searchContext);
    }

    public IndexerPostProcessor[] getIndexerPostProcessors() {
        Stream<IndexerPostProcessor> stream = this._indexerPostProcessorsHolder.stream();
        return (IndexerPostProcessor[])stream.toArray(IndexerPostProcessor[]::new);
    }

    public String getPortletId() {
        return "";
    }

    public String[] getSearchClassNames() {
        return this._modelSearchSettings.getSearchClassNames();
    }

    public String getSearchEngineId() {
        return "SYSTEM_ENGINE";
    }

    public String getSortField(String orderByCol) {
        return "";
    }

    public String getSortField(String orderByCol, int sortType) {
        return "";
    }

    public Summary getSummary(Document document, Locale locale, String snippet) throws SearchException {
        return this.getSummary(document, snippet, null, null);
    }

    public Summary getSummary(Document document, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws SearchException {
        return this._indexerSummaryBuilder.getSummary(document, snippet, this._getLocale(portletRequest));
    }

    public int hashCode() {
        String[] searchClassNames = this.getSearchClassNames();
        StringBundler sb = new StringBundler(searchClassNames.length);
        for (String searchClassName : searchClassNames) {
            sb.append(searchClassName);
        }
        return HashUtil.hash((int)0, (Object)sb.toString());
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._indexerPermissionPostFilter.hasPermission(permissionChecker, entryClassPK);
    }

    public boolean isCommitImmediately() {
        return this._modelSearchSettings.isCommitImmediately();
    }

    public boolean isFilterSearch() {
        return this.isPermissionAware();
    }

    public boolean isIndexerEnabled() {
        return this._indexerWriter.isEnabled();
    }

    public boolean isPermissionAware() {
        return this._indexerPermissionPostFilter.isPermissionAware();
    }

    public boolean isStagingAware() {
        return this._modelSearchSettings.isStagingAware();
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        return this._indexerPermissionPostFilter.isVisible(classPK, status);
    }

    public boolean isVisibleRelatedEntry(long classPK, int status) throws Exception {
        return true;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this._indexerQueryBuilderImpl.addPreFiltersFromModel(contextBooleanFilter, this._modelSearchSettings, searchContext);
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this._indexerQueryBuilderImpl.addSearchTermsFromModel(searchQuery, searchContext);
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
    }

    public void registerIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor) {
        this._indexerPostProcessorsHolder.addIndexerPostProcessor(indexerPostProcessor);
    }

    public void reindex(Collection<T> objects) throws SearchException {
        this._indexerWriter.reindex(objects);
    }

    public void reindex(String className, long classPK) throws SearchException {
        this._indexerWriter.reindex(classPK);
    }

    public void reindex(String[] ids) throws SearchException {
        this._indexerWriter.reindex(ids);
    }

    public void reindex(T baseModel) throws SearchException {
        this._indexerWriter.reindex(baseModel);
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        return this._indexerSearcher.search(searchContext);
    }

    public Hits search(SearchContext searchContext, String ... selectedFieldNames) throws SearchException {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setSelectedFieldNames(selectedFieldNames);
        return this.search(searchContext);
    }

    public long searchCount(SearchContext searchContext) throws SearchException {
        return this._indexerSearcher.searchCount(searchContext);
    }

    public void setIndexerEnabled(boolean indexerEnabled) {
        this._indexerWriter.setEnabled(indexerEnabled);
    }

    public void unregisterIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor) {
        this._indexerPostProcessorsHolder.removeIndexerPostProcessor(indexerPostProcessor);
    }

    private Locale _getLocale(PortletRequest portletRequest) {
        if (portletRequest != null) {
            return portletRequest.getLocale();
        }
        return LocaleUtil.getMostRelevantLocale();
    }
}

