/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ResourcedModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.search.indexer.BaseModelDocumentFactory;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={BaseModelDocumentFactory.class})
public class BaseModelDocumentFactoryImpl
implements BaseModelDocumentFactory {
    private final Document _document = new DocumentImpl();

    public Document createDocument(BaseModel<?> baseModel) {
        Document document = (Document)this._document.clone();
        String className = baseModel.getModelClassName();
        Tuple classPKResourcePrimKeyTuple = this.getClassPKResourcePrimKey(baseModel);
        long classPK = (Long)classPKResourcePrimKeyTuple.getObject(0);
        String uid = this.getDocumentUID(className, classPK);
        document.addKeyword("uid", uid);
        DocumentHelper documentHelper = new DocumentHelper(document);
        long resourcePrimKey = (Long)classPKResourcePrimKeyTuple.getObject(1);
        documentHelper.setEntryKey(className, classPK);
        if (resourcePrimKey > 0L) {
            document.addKeyword("rootEntryClassPK", resourcePrimKey);
        }
        return document;
    }

    protected Tuple getClassPKResourcePrimKey(BaseModel<?> baseModel) {
        long classPK = 0L;
        long resourcePrimKey = 0L;
        if (baseModel instanceof ResourcedModel) {
            ResourcedModel resourcedModel = (ResourcedModel)baseModel;
            classPK = resourcedModel.getResourcePrimKey();
            resourcePrimKey = resourcedModel.getResourcePrimKey();
        } else {
            classPK = (Long)baseModel.getPrimaryKeyObj();
        }
        Tuple tuple = new Tuple(new Object[]{classPK, resourcePrimKey});
        return tuple;
    }

    protected String getDocumentUID(String className, long classPK) {
        String uid = Field.getUID((String)className, (String)String.valueOf(classPK));
        return uid;
    }
}

