/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.index;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.search.configuration.IndexWriterHelperConfiguration;
import com.liferay.portal.search.index.IndexStatusManager;
import com.liferay.portal.search.index.UpdateDocumentIndexWriter;
import com.liferay.portal.search.permission.SearchPermissionDocumentContributor;
import java.util.Collection;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.configuration.IndexWriterHelperConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={UpdateDocumentIndexWriter.class})
public class UpdateDocumentIndexWriterImpl
implements UpdateDocumentIndexWriter {
    @Reference
    protected IndexStatusManager indexStatusManager;
    @Reference
    protected SearchEngineHelper searchEngineHelper;
    @Reference
    protected SearchPermissionDocumentContributor searchPermissionDocumentContributor;
    private static final Log _log = LogFactoryUtil.getLog(UpdateDocumentIndexWriterImpl.class);
    private volatile boolean _commitImmediately;

    public void updateDocument(String searchEngineId, long companyId, Document document, boolean commitImmediately) {
        if (this.indexStatusManager.isIndexReadOnly() || document == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + document.toString()));
        }
        SearchEngine searchEngine = this.searchEngineHelper.getSearchEngine(searchEngineId);
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        this.searchPermissionDocumentContributor.addPermissionFields(companyId, document);
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setSearchEngineId(searchEngineId);
        this.setCommitImmediately(searchContext, commitImmediately || ProxyModeThreadLocal.isForceSync());
        try {
            indexWriter.updateDocument(searchContext, document);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
    }

    public void updateDocumentPartially(String searchEngineId, long companyId, Document document, boolean commitImmediately) {
        if (this.indexStatusManager.isIndexReadOnly() || document == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + document.toString()));
        }
        SearchEngine searchEngine = this.searchEngineHelper.getSearchEngine(searchEngineId);
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setSearchEngineId(searchEngineId);
        this.setCommitImmediately(searchContext, commitImmediately);
        try {
            indexWriter.partiallyUpdateDocument(searchContext, document);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
    }

    public void updateDocuments(String searchEngineId, long companyId, Collection<Document> documents, boolean commitImmediately) {
        if (this.indexStatusManager.isIndexReadOnly() || documents == null || documents.isEmpty()) {
            return;
        }
        SearchEngine searchEngine = this.searchEngineHelper.getSearchEngine(searchEngineId);
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        for (Document document : documents) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Document " + document.toString()));
            }
            this.searchPermissionDocumentContributor.addPermissionFields(companyId, document);
        }
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setSearchEngineId(searchEngineId);
        this.setCommitImmediately(searchContext, commitImmediately);
        try {
            indexWriter.updateDocuments(searchContext, documents);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
    }

    public void updateDocumentsPartially(String searchEngineId, long companyId, Collection<Document> documents, boolean commitImmediately) {
        if (this.indexStatusManager.isIndexReadOnly() || documents == null || documents.isEmpty()) {
            return;
        }
        SearchEngine searchEngine = this.searchEngineHelper.getSearchEngine(searchEngineId);
        IndexWriter indexWriter = searchEngine.getIndexWriter();
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setSearchEngineId(searchEngineId);
        this.setCommitImmediately(searchContext, commitImmediately);
        try {
            indexWriter.partiallyUpdateDocuments(searchContext, documents);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        IndexWriterHelperConfiguration indexWriterHelperConfiguration = (IndexWriterHelperConfiguration)ConfigurableUtil.createConfigurable(IndexWriterHelperConfiguration.class, properties);
        this._commitImmediately = indexWriterHelperConfiguration.indexCommitImmediately();
    }

    protected void setCommitImmediately(SearchContext searchContext, boolean commitImmediately) {
        if (!commitImmediately) {
            searchContext.setCommitImmediately(this._commitImmediately);
        } else {
            searchContext.setCommitImmediately(true);
        }
    }
}

