/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.index;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.search.IndexStatusManagerThreadLocal;
import com.liferay.portal.search.configuration.IndexStatusManagerConfiguration;
import com.liferay.portal.search.index.IndexStatusManager;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.search.configuration.IndexStatusManagerConfiguration"}, immediate=true, service={IndexStatusManager.class})
public class IndexStatusManagerImpl
implements IndexStatusManager {
    private volatile boolean _indexReadOnly;
    private final Set<String> _indexReadOnlyModels = Collections.newSetFromMap(new ConcurrentHashMap());

    public boolean isIndexReadOnly() {
        return IndexStatusManagerThreadLocal.isIndexReadOnly() || this._indexReadOnly;
    }

    public boolean isIndexReadOnly(String className) {
        return this._indexReadOnlyModels.contains(className);
    }

    public void setIndexReadOnly(boolean indexReadOnly) {
        this._indexReadOnly = indexReadOnly;
    }

    public void setIndexReadOnly(String className, boolean indexReadOnly) {
        if (indexReadOnly) {
            this._indexReadOnlyModels.add(className);
        } else {
            this._indexReadOnlyModels.remove(className);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        IndexStatusManagerConfiguration indexStatusManagerConfiguration = (IndexStatusManagerConfiguration)ConfigurableUtil.createConfigurable(IndexStatusManagerConfiguration.class, properties);
        this._indexReadOnly = indexStatusManagerConfiguration.indexReadOnly();
    }
}

