/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.hits;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcherHelperUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.hits.HitsProcessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"sort.order=3"}, service={HitsProcessor.class})
public class QuerySuggestionHitsProcessor
implements HitsProcessor {
    public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isQuerySuggestionEnabled()) {
            return true;
        }
        if (hits.getLength() >= queryConfig.getQuerySuggestionScoresThreshold()) {
            return true;
        }
        String[] querySuggestions = IndexSearcherHelperUtil.suggestKeywordQueries((SearchContext)searchContext, (int)queryConfig.getQuerySuggestionMax());
        querySuggestions = ArrayUtil.remove((String[])querySuggestions, (String)searchContext.getKeywords());
        hits.setQuerySuggestions(querySuggestions);
        return true;
    }
}

