/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.hits;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.hits.HitsProcessor;
import com.liferay.portal.kernel.search.hits.HitsProcessorRegistry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={HitsProcessorRegistry.class})
public class HitsProcessorRegistryImpl
implements HitsProcessorRegistry {
    private final Set<SortableHitsProcessor> _hitsProcessors = new ConcurrentSkipListSet<SortableHitsProcessor>();

    public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
        HitsProcessor hitsProcessor;
        if (this._hitsProcessors.isEmpty()) {
            return false;
        }
        if (Validator.isNull((String)searchContext.getKeywords())) {
            return false;
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isHitsProcessingEnabled()) {
            return false;
        }
        Iterator<SortableHitsProcessor> iterator = this._hitsProcessors.iterator();
        while (iterator.hasNext() && (hitsProcessor = (HitsProcessor)iterator.next()).process(searchContext, hits)) {
        }
        return true;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addHitsProcessor(HitsProcessor hitsProcessor, Map<String, Object> properties) {
        String sortOrderString = (String)properties.get("sort.order");
        Integer sortOrder = null;
        if (Validator.isNotNull((String)sortOrderString)) {
            sortOrder = GetterUtil.getInteger((String)sortOrderString);
        }
        SortableHitsProcessor sortableHitsProcessor = new SortableHitsProcessor(hitsProcessor, sortOrder);
        this._hitsProcessors.add(sortableHitsProcessor);
    }

    protected void removeHitsProcessor(HitsProcessor hitsProcessor, Map<String, Object> properties) {
        String sortOrderString = (String)properties.get("sort.order");
        Integer sortOrder = null;
        if (Validator.isNotNull((String)sortOrderString)) {
            sortOrder = GetterUtil.getInteger((String)sortOrderString);
        }
        SortableHitsProcessor sortableHitsProcessor = new SortableHitsProcessor(hitsProcessor, sortOrder);
        this._hitsProcessors.remove(sortableHitsProcessor);
    }

    private static class SortableHitsProcessor
    implements Comparable<SortableHitsProcessor>,
    HitsProcessor {
        private final HitsProcessor _hitsProcessor;
        private Integer _sortOrder;

        public SortableHitsProcessor(HitsProcessor hitsProcessor, Integer sortOrder) {
            this._hitsProcessor = hitsProcessor;
            this._sortOrder = sortOrder;
        }

        @Override
        public int compareTo(SortableHitsProcessor sortableHitsProcessor) {
            if (sortableHitsProcessor._sortOrder == null && this._sortOrder != null) {
                return 1;
            }
            if (sortableHitsProcessor._sortOrder != null && this._sortOrder == null) {
                return -1;
            }
            if (sortableHitsProcessor._sortOrder == null && this._sortOrder == null) {
                return 0;
            }
            return this._sortOrder.compareTo(sortableHitsProcessor._sortOrder);
        }

        public boolean equals(Object object) {
            SortableHitsProcessor sortableHitsProcessor = (SortableHitsProcessor)object;
            return sortableHitsProcessor._hitsProcessor.equals(this._hitsProcessor);
        }

        public int hashCode() {
            return this._hitsProcessor.hashCode();
        }

        public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
            return this._hitsProcessor.process(searchContext, hits);
        }
    }
}

