/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.hits;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcherHelperUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.hits.HitsProcessor;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"sort.order=0"}, service={HitsProcessor.class})
public class CollatedSpellCheckHitsProcessor
implements HitsProcessor {
    public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isCollatedSpellCheckResultEnabled()) {
            return true;
        }
        int collatedSpellCheckResultScoresThreshold = queryConfig.getCollatedSpellCheckResultScoresThreshold();
        if (hits.getLength() >= collatedSpellCheckResultScoresThreshold) {
            return true;
        }
        String collatedKeywords = IndexSearcherHelperUtil.spellCheckKeywords((SearchContext)searchContext);
        if (collatedKeywords.equals(searchContext.getKeywords())) {
            collatedKeywords = "";
        }
        hits.setCollatedSpellCheckResult(collatedKeywords);
        return true;
    }
}

