/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.hits;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcherHelperUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.facet.faceted.searcher.FacetedSearcher;
import com.liferay.portal.kernel.search.facet.faceted.searcher.FacetedSearcherManager;
import com.liferay.portal.kernel.search.hits.HitsProcessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"sort.order=1"}, service={HitsProcessor.class})
public class AlternateKeywordQueryHitsProcessor
implements HitsProcessor {
    @Reference
    protected FacetedSearcherManager facetedSearcherManager;

    public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
        if (hits.getLength() > 0) {
            return true;
        }
        Map spellCheckResults = hits.getSpellCheckResults();
        if (spellCheckResults == null) {
            return true;
        }
        FacetedSearcher facetedSearcher = this.facetedSearcherManager.createFacetedSearcher();
        String spellCheckedKeywords = hits.getCollatedSpellCheckResult();
        searchContext.overrideKeywords(spellCheckedKeywords);
        Object[] querySuggestions = IndexSearcherHelperUtil.suggestKeywordQueries((SearchContext)searchContext, (int)5);
        if (ArrayUtil.isNotEmpty((Object[])querySuggestions)) {
            searchContext.setKeywords((String)querySuggestions[0]);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHitsProcessingEnabled(false);
        Hits alternateResults = facetedSearcher.search(searchContext);
        hits.copy(alternateResults);
        return true;
    }
}

