/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.facet;

import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.RangeFacet;
import com.liferay.portal.kernel.search.facet.util.RangeParserUtil;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.generic.BooleanClauseImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.facet.Facet;
import com.liferay.portal.search.filter.DateRangeFilterBuilder;
import com.liferay.portal.search.filter.FilterBuilders;

public class ModifiedFacetImpl
extends RangeFacet
implements Facet {
    private String _aggregationName;
    private final FilterBuilders _filterBuilders;
    private String[] _selections = new String[0];

    public ModifiedFacetImpl(String fieldName, SearchContext searchContext, FilterBuilders filterBuilders) {
        super(searchContext);
        this.setFieldName(fieldName);
        this._filterBuilders = filterBuilders;
    }

    public String getAggregationName() {
        if (this._aggregationName != null) {
            return this._aggregationName;
        }
        return this.getFieldName();
    }

    public String[] getSelections() {
        return this._selections;
    }

    public void select(String ... selections) {
        this._selections = selections;
    }

    public void setAggregationName(String aggregationName) {
        this._aggregationName = aggregationName;
    }

    protected BooleanClause<Filter> doGetFacetFilterBooleanClause() {
        if (ArrayUtil.isEmpty((Object[])this._selections)) {
            return null;
        }
        String rangeString = this._selections[0];
        String start = "";
        String end = "";
        if (!this.isStatic() && Validator.isNotNull((String)rangeString)) {
            String[] range = RangeParserUtil.parserRange((String)rangeString);
            start = range[0];
            end = range[1];
        }
        if (Validator.isNull((String)start) && Validator.isNull((String)end)) {
            return null;
        }
        DateRangeFilterBuilder dateRangeFilterBuilder = this._filterBuilders.dateRangeFilterBuilder();
        dateRangeFilterBuilder.setFieldName(this.getFieldName());
        if (Validator.isNotNull((String)start)) {
            dateRangeFilterBuilder.setFrom(start);
        }
        dateRangeFilterBuilder.setIncludeLower(true);
        dateRangeFilterBuilder.setIncludeUpper(true);
        if (Validator.isNotNull((String)end)) {
            dateRangeFilterBuilder.setTo(end);
        }
        return new BooleanClauseImpl((Object)dateRangeFilterBuilder.build(), BooleanClauseOccur.MUST);
    }
}

