/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.expando;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.util.ExpandoBridgeFactory;
import com.liferay.expando.kernel.util.ExpandoBridgeIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;

public class ExpandoQueryContributorHelper {
    private boolean _andSearch;
    private BooleanQuery _booleanQuery;
    private Stream<String> _classNamesStream = Stream.empty();
    private long _companyId;
    private final ExpandoBridgeFactory _expandoBridgeFactory;
    private final ExpandoBridgeIndexer _expandoBridgeIndexer;
    private final ExpandoColumnLocalService _expandoColumnLocalService;
    private String _keywords;
    private Locale _locale;
    private final Localization _localization;

    public ExpandoQueryContributorHelper(ExpandoBridgeFactory expandoBridgeFactory, ExpandoBridgeIndexer expandoBridgeIndexer, ExpandoColumnLocalService expandoColumnLocalService, Localization localization) {
        this._expandoBridgeFactory = expandoBridgeFactory;
        this._expandoBridgeIndexer = expandoBridgeIndexer;
        this._expandoColumnLocalService = expandoColumnLocalService;
        this._localization = localization;
    }

    public void contribute() {
        if (Validator.isBlank((String)this._keywords)) {
            return;
        }
        this._classNamesStream.forEach(this::contribute);
    }

    public void setAndSearch(boolean andSearch) {
        this._andSearch = andSearch;
    }

    public void setBooleanQuery(BooleanQuery booleanQuery) {
        this._booleanQuery = booleanQuery;
    }

    public void setClassNamesStream(Stream<String> classNamesStream) {
        this._classNamesStream = classNamesStream;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setKeywords(String keywords) {
        this._keywords = keywords;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    protected void contribute(String className) {
        ExpandoBridge expandoBridge = this._expandoBridgeFactory.getExpandoBridge(this._companyId, className);
        Set attributeNames = SetUtil.fromEnumeration((Enumeration)expandoBridge.getAttributeNames());
        for (String attributeName : attributeNames) {
            this.contribute(attributeName, expandoBridge);
        }
    }

    protected void contribute(String attributeName, ExpandoBridge expandoBridge) {
        UnicodeProperties properties = expandoBridge.getAttributeProperties(attributeName);
        int indexType = GetterUtil.getInteger((String)properties.getProperty("index-type"));
        if (indexType == 0) {
            return;
        }
        String fieldName = this.getExpandoFieldName(attributeName, expandoBridge);
        boolean like = false;
        if (indexType == 1) {
            like = true;
        }
        if (this._andSearch) {
            this._booleanQuery.addRequiredTerm(fieldName, this._keywords, like);
        } else {
            this._addTerm(this._booleanQuery, fieldName, this._keywords, like);
        }
    }

    protected String getExpandoFieldName(String attributeName, ExpandoBridge expandoBridge) {
        ExpandoColumn expandoColumn = this._expandoColumnLocalService.getDefaultTableColumn(expandoBridge.getCompanyId(), expandoBridge.getClassName(), attributeName);
        UnicodeProperties unicodeProperties = expandoColumn.getTypeSettingsProperties();
        int indexType = GetterUtil.getInteger((String)unicodeProperties.getProperty("index-type"));
        String fieldName = this._expandoBridgeIndexer.encodeFieldName(attributeName, indexType);
        if (expandoColumn.getType() == 20) {
            fieldName = this.getLocalizedName(fieldName);
        }
        return fieldName;
    }

    protected String getLocalizedName(String name) {
        if (this._locale == null) {
            return name;
        }
        return this._localization.getLocalizedName(name, LocaleUtil.toLanguageId((Locale)this._locale));
    }

    private Query _addTerm(BooleanQuery booleanQuery, String fieldName, String keywords, boolean like) {
        try {
            return booleanQuery.addTerm(fieldName, keywords, like);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }
}

