/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.contributor.query;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.configuration.DefaultKeywordQueryConfiguration;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.configuration.DefaultKeywordQueryConfiguration"}, immediate=true, service={KeywordQueryContributor.class})
public class DefaultKeywordQueryContributor
implements KeywordQueryContributor {
    @Reference
    protected QueryHelper queryHelper;
    private static final Log _log = LogFactoryUtil.getLog(DefaultKeywordQueryContributor.class);
    private volatile Set<String> _disabledEntryClassNames;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        String entryClassName = keywordQueryContributorHelper.getClassName();
        if (SetUtil.isNotEmpty(this._disabledEntryClassNames) && this._disabledEntryClassNames.contains(entryClassName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(DefaultKeywordQueryContributor.class.getName() + " is disabled for " + entryClassName));
            }
            return;
        }
        if (Validator.isBlank((String)keywords)) {
            SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
            this.queryHelper.addSearchTerm(booleanQuery, searchContext, "description", false);
            this.queryHelper.addSearchTerm(booleanQuery, searchContext, "title", false);
            this.queryHelper.addSearchTerm(booleanQuery, searchContext, "userName", false);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        DefaultKeywordQueryConfiguration defaultKeywordQueryConfiguration = (DefaultKeywordQueryConfiguration)ConfigurableUtil.createConfigurable(DefaultKeywordQueryConfiguration.class, properties);
        this._disabledEntryClassNames = SetUtil.fromArray((Object[])defaultKeywordQueryConfiguration.disabledEntryClassNames());
    }
}

