/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.contributor.query;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.query.FieldQueryFactory;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={KeywordQueryContributor.class})
public class AlwaysPresentFieldsKeywordQueryContributor
implements KeywordQueryContributor {
    @Reference
    protected FieldQueryFactory fieldQueryFactory;
    private static final String[] _ALWAYS_PRESENT_FIELDS = new String[]{"comments", "content", "description", "properties", "title", "url", "userName"};

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        if (Validator.isBlank((String)keywords)) {
            return;
        }
        for (String field : _ALWAYS_PRESENT_FIELDS) {
            Query query = this.fieldQueryFactory.createQuery(field, keywords, false, false);
            try {
                booleanQuery.add(query, BooleanClauseOccur.SHOULD);
            }
            catch (ParseException pe) {
                throw new SystemException((Throwable)pe);
            }
        }
    }
}

