/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.contributor.document;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.internal.contributor.document.GroupUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=-10000"}, service={DocumentContributor.class})
public class StagingDocumentContributor
implements DocumentContributor {
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected IndexerRegistry indexerRegistry;

    public void contribute(Document document, BaseModel baseModel) {
        String className = document.get("entryClassName");
        if (Validator.isNull((String)className)) {
            return;
        }
        Indexer indexer = this.indexerRegistry.getIndexer(className);
        if (!indexer.isStagingAware()) {
            return;
        }
        Map fields = document.getFields();
        Field groupIdField = (Field)fields.get("groupId");
        if (groupIdField == null) {
            return;
        }
        long groupId = GetterUtil.getLong((String)groupIdField.getValue());
        document.addKeyword("stagingGroup", this.isStagingGroup(groupId));
    }

    protected boolean isStagingGroup(long groupId) {
        Group group = GroupUtil.fetchSiteGroup(this.groupLocalService, groupId);
        if (group == null) {
            return false;
        }
        return group.isStagingGroup();
    }
}

